% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/y_labeler.R
\name{y_labeler}
\alias{y_labeler}
\title{Generate y-axis Label Based on SWMP Parameter Abbreviation}
\usage{
y_labeler(param, converted = FALSE)
}
\arguments{
\item{param}{chr string of variable abbreviation}

\item{converted}{logical, should the parameter label units be converted from metric to english? Defaults to \code{FALSE}. Currently available for \code{temp}, \code{depth}, \code{cdepth}, \code{level}, \code{clevel}, \code{atemp}, \code{wspd}, \code{maxwspd}, and \code{totprcp}}
}
\value{
Returns character vector or an unevaluated expression
}
\description{
Generate a y-axis label based on SWMP parameter abbreviation
}
\details{
A helper function used internally by several plotting functions to generate y-axis labels. This function does not convert sample results from metric to english. It only adjusts the units in the y-axis label.
}
\examples{
\dontrun{
y_lab <- y_labeler('do_mgl')
}

}
\author{
Julie Padilla
}
\concept{
miscellaneous
}
