% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swmpr_analyze.R
\name{smoother}
\alias{smoother}
\alias{smoother.default}
\alias{smoother.swmpr}
\title{Smooth swmpr data}
\usage{
smoother(x, ...)

\method{smoother}{default}(x, window = 5, sides = 2, ...)

\method{smoother}{swmpr}(x, params = NULL, ...)
}
\arguments{
\item{x}{input object}

\item{...}{arguments passed to or from other methods}

\item{window}{numeric vector defining size of the smoothing window, passed to \code{filter}}

\item{sides}{numeric vector defining method of averaging, passed to \code{filter}}

\item{params}{is chr string of swmpr parameters to smooth, default all}
}
\value{
Returns a filtered swmpr object. QAQC columns are removed if included with input object.
}
\description{
Smooth swmpr data with a moving window average
}
\details{
The \code{smoother} function can be used to smooth parameters in a swmpr object using a specified window size. This method is a simple wrapper to \code{\link[stats]{filter}}. The window argument specifies the number of observations included in the moving average. The sides argument specifies how the average is calculated for each observation (see the documentation for \code{\link[stats]{filter}}). A value of 1 will filter observations within the window that are previous to the current observation, whereas a value of 2 will filter all observations within the window centered at zero lag from the current observation. The params argument specifies which parameters to smooth.
}
\examples{
## import data
data(apadbwq)
swmp1 <- apadbwq

## qaqc and subset imported data
dat <- qaqc(swmp1)
dat <- subset(dat, subset = c('2012-07-09 00:00', '2012-07-24 00:00'))

## filter
test <- smoother(dat, window = 50, params = 'do_mgl')

## plot to see the difference
plot(do_mgl ~ datetimestamp, data = dat, type = 'l')
lines(test, select = 'do_mgl', col = 'red', lwd = 2)
}
\seealso{
\code{\link[stats]{filter}}
}
\concept{
analyze
}
