% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf2raster.R
\name{sf2raster}
\alias{sf2raster}
\title{Convert simple features object into regularly spaced raster}
\usage{
sf2raster(
  polyz_from = NULL,
  pointz_from = NULL,
  input_variable = NULL,
  reverse = FALSE,
  poly_to = NULL,
  return_output = NULL,
  return_field = NULL,
  aggregate_function = list(function(x) mean(x, na.rm = TRUE)),
  reverse_function = list(function(x) mean(x, na.rm = TRUE)),
  grid_res = c(1000, 1000),
  cartogram = FALSE,
  carto_var = NULL,
  message_out = TRUE,
  return_list = FALSE
)
}
\arguments{
\item{polyz_from}{Source polygon layer. \code{sf} object.}

\item{pointz_from}{Source point layer. \code{sf} object.}

\item{input_variable}{Name of input variable from source layer. Character string.}

\item{reverse}{Reverse translation from raster layer to \code{sf} polygon object (polygon features only). Default is \code{FALSE}.}

\item{poly_to}{Destination polygon layer for reverse conversion. Must be specified if \code{reverse=TRUE}. \code{sf} object.}

\item{return_output}{Return output for reverse conversion. Must be specified if \code{reverse=TRUE}.}

\item{return_field}{Return field for reverse conversion. Must be specified if \code{reverse=TRUE}.}

\item{aggregate_function}{Aggregation function to be applied to variables specified in \code{input_variable}. Must take as an input a numeric vector \code{x}. Function or list of functions. Default is \code{mean}.}

\item{reverse_function}{Aggregation function for reverse conversion. Must be specified if \code{reverse=TRUE}. Function or list of functions. Default is \code{mean}.}

\item{grid_res}{Resolution of raster grid, in meters. Numerical vector of length 2 (number of rows, number of columns). Default is \code{c(1000,1000)}.}

\item{cartogram}{Cartogram transformation. Logical. Default is \code{FALSE}.}

\item{carto_var}{Input variable for cartogram transformation. Must be specified if \code{cartogram=TRUE}. Character string.}

\item{message_out}{Print informational messages. Logical. Default is \code{TRUE}.}

\item{return_list}{Return full set of results, including input polygons, centroids and field raster. Default is \code{FALSE}. Logical.}
}
\value{
If \code{return_list=FALSE} (default) and \code{reverse=FALSE} (default), returns \code{RasterLayer} object, with cell values corresponding to \code{input_variable}.

If \code{return_list=TRUE} and input layer is polygon, returns a list containing
\itemize{
 \item{"return_output". }{Output raster, with values corresponding to \code{input_variable}. \code{RasterLayer} object.}
 \item{"return_centroid". }{Raster of centroids, with values corresponding to \code{input_variable}. \code{RasterLayer} object.}
 \item{"poly_to". }{Source polygons, with columns corresponding to \code{input_variable} and auto-generated numerical ID \code{Field}. \code{sf} object.}
 \item{"return_field". }{Output raster, with values corresponding to auto-generated numerical ID \code{Field}. \code{RasterLayer} object.}
 }
If \code{return_list=TRUE} and  input layer is points, returns a list containing
\itemize{
 \item{"return_output". }{Output raster, with values corresponding to \code{input_variable}. \code{RasterLayer} object.}
 \item{"return_point". }{Source points, with column corresponding to \code{input_variable}.}
 }
If \code{reverse=TRUE}, returns an \code{sf} polygon layer, with columns corresponding to \code{input_variable} and auto-generated numerical ID \code{Field}.
}
\description{
This function takes in an \code{sf} spatial object (polygon or point) and returns a regularly spaced RasterLayer. Reverse translation option allows users to create an \code{sf} polygon object from the regularly spaced RasterLayer. This function can also conver the \code{sf} object into a cartogram with a user-specified variable name.
}
\examples{
# Rasterization of polygon layer.
\dontrun{
data(clea_deu2009)
out_1 <- sf2raster(polyz_from = utm_select(clea_deu2009),
                   input_variable = "to1")
raster::plot(out_1)
}
# Rasterization of point layer
\dontrun{
data(clea_deu2009_pt)
out_2 <- sf2raster(pointz_from = utm_select(clea_deu2009_pt),
                   input_variable = "to1",
                   grid_res = c(25000,25000))
raster::plot(out_2)
}
# Cartogram (vote turnout scaled by number of valid votes)
\dontrun{
out_3 <- sf2raster(polyz_from = utm_select(clea_deu2009),
                   input_variable = "to1",
                   cartogram = TRUE,
                   carto_var = "vv1")
raster::plot(out_3)
}
# Polygonization of cartogram raster
\dontrun{
out_4a <- sf2raster(polyz_from = utm_select(clea_deu2009),
                    input_variable = "to1",
                    cartogram = TRUE,
                    carto_var = "vv1",
                    return_list = TRUE)
out_4 <- sf2raster(reverse = TRUE,
                   poly_to = out_4a$poly_to,
                   return_output = out_4a$return_output,
                   return_field = out_4a$return_field)
raster::plot(out_4)
}
}
