% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_simData.R
\name{plot_simData}
\alias{plot_simData}
\title{Visualizing the simulated data using image map and 3D visualization}
\usage{
plot_simData(sim_object, type = "heatmap")
}
\arguments{
\item{sim_object}{R object containing simulated data to be plotted}

\item{type}{type of the plot. Heatmap for image plot and 3D for persp 3D plot}
}
\value{
The function generates and displays a plot based on the specified \code{type}.
If \code{type} is "heatmap", the function displays a 2D heatmap of the simulated data.
If \code{type} is "3D", the function creates a 3D surface plot of the simulated data.
The function does not return any values but generates the requested plot as a side effect.
}
\description{
Visualizing the simulated data using image map and 3D visualization
}
\examples{
# Examples
output_obj <- OmixCraftHD(
  vector_features = c(2000,3000),
  sigmas_vector=c(8,5),
  n_samples=100,
  n_factors=5,
  num.factor='multiple',
  advanced_dist='mixed'
)
plot_simData(sim_object = output_obj, type = "heatmap")
plot_simData(sim_object = output_obj, type = "3D")
}
