% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertical-planning.R
\name{vertical_planning_functions}
\alias{vertical_planning_functions}
\alias{vertical_planning}
\alias{vertical_constant}
\alias{vertical_linear}
\alias{vertical_linear_reverse}
\alias{vertical_block}
\alias{vertical_block_variant}
\alias{vertical_rep_accumulation}
\alias{vertical_set_accumulation}
\alias{vertical_set_accumulation_reverse}
\alias{vertical_undulating}
\alias{vertical_undulating_reverse}
\alias{vertical_block_undulating}
\alias{vertical_volume_intensity}
\alias{.vertical_rep_accumulation.post}
\title{Vertical Planning Functions}
\usage{
vertical_planning(reps, reps_change = NULL, step = NULL)

vertical_constant(reps, n_steps = 4)

vertical_linear(reps, reps_change = c(0, -1, -2, -3))

vertical_linear_reverse(reps, reps_change = c(0, 1, 2, 3))

vertical_block(reps, step = c(-2, -1, 0, -3))

vertical_block_variant(reps, step = c(-2, -1, -3, 0))

vertical_rep_accumulation(
  reps,
  reps_change = c(-3, -2, -1, 0),
  step = c(0, 0, 0, 0)
)

vertical_set_accumulation(
  reps,
  step = c(-2, -2, -2, -2),
  reps_change = rep(0, length(step)),
  accumulate_set = length(reps),
  set_increment = 1,
  sequence = TRUE
)

vertical_set_accumulation_reverse(
  reps,
  step = c(-3, -2, -1, 0),
  reps_change = rep(0, length(step)),
  accumulate_set = length(reps),
  set_increment = 1,
  sequence = TRUE
)

vertical_undulating(reps, reps_change = c(0, -2, -1, -3))

vertical_undulating_reverse(reps, reps_change = c(0, 2, 1, 3))

vertical_block_undulating(
  reps,
  reps_change = c(0, -2, -1, -3),
  step = c(-2, -1, -3, 0)
)

vertical_volume_intensity(reps, reps_change = c(0, 0, -3, -3))

.vertical_rep_accumulation.post(
  scheme,
  rep_decrement = c(-3, -2, -1, 0),
  remove_reps = TRUE
)
}
\arguments{
\item{reps}{Numeric vector indicating reps prescription}

\item{reps_change}{Change in \code{reps} across progression steps}

\item{step}{Numeric vector indicating progression steps (i.e. -3, -2, -1, 0)}

\item{n_steps}{Number of progression steps. Default is 4}

\item{accumulate_set}{Which set (position in \code{reps}) to accumulate}

\item{set_increment}{How many sets to increase each step? Default is 1}

\item{sequence}{Should the sequence of accumulated sets be repeated, or
individual sets?}

\item{scheme}{Scheme generated by \code{scheme_} functions}

\item{rep_decrement}{Rep decrements across progression step}

\item{remove_reps}{Should < 1 reps be removed?}
}
\value{
Data frame with \code{reps}, \code{index}, and \code{step} columns
}
\description{
Functions for creating vertical planning (progressions)
}
\section{Functions}{
\itemize{
\item \code{vertical_planning()}: Generic Vertical Planning

\item \code{vertical_constant()}: Constants Vertical Planning

\item \code{vertical_linear()}: Linear Vertical Planning

\item \code{vertical_linear_reverse()}: Reverse Linear Vertical Planning

\item \code{vertical_block()}: Block Vertical Planning

\item \code{vertical_block_variant()}: Block Variant Vertical Planning

\item \code{vertical_rep_accumulation()}: Rep Accumulation Vertical Planning

\item \code{vertical_set_accumulation()}: Set Accumulation Vertical Planning

\item \code{vertical_set_accumulation_reverse()}: Set Accumulation Reverse Vertical Planning

\item \code{vertical_undulating()}: Undulating Vertical Planning

\item \code{vertical_undulating_reverse()}: Undulating Vertical Planning

\item \code{vertical_block_undulating()}: Block Undulating Vertical Planning

\item \code{vertical_volume_intensity()}: Volume-Intensity Vertical Planning

\item \code{.vertical_rep_accumulation.post()}: Rep Accumulation Vertical Planning POST treatment
This functions is to be applied AFTER scheme is generated. Other options is to use
\code{\link{scheme_rep_acc}} function, that is flexible enough to generate most options,
except for the \code{\link{scheme_ladder}} and \code{\link{scheme_light_heavy}}. Please note
that the \code{adjustment} column in the output will be wrong, hence set to \code{NA}

}}
\examples{
# Generic vertical planning function
# ----------------------------------

# Constant
vertical_planning(reps = c(3, 2, 1), step = c(-3, -2, -1, 0))

# Linear
vertical_planning(reps = c(5, 5, 5, 5, 5), reps_change = c(0, -1, -2))

# Reverse Linear
vertical_planning(reps = c(5, 5, 5, 5, 5), reps_change = c(0, 1, 2))

# Block
vertical_planning(reps = c(5, 5, 5, 5, 5), step = c(-2, -1, 0, -3))

# Block variant
vertical_planning(reps = c(5, 5, 5, 5, 5), step = c(-2, -1, -3, 0))

# Undulating
vertical_planning(reps = c(12, 10, 8), reps_change = c(0, -4, -2, -6))

# Undulating + Block variant
vertical_planning(
  reps = c(12, 10, 8),
  reps_change = c(0, -4, -2, -6),
  step = c(-2, -1, -3, 0)
)

# Rep accumulation
# If used with `scheme_generic()` (or any other `scheme_`) it will provide wrong set and rep scheme.
# Use `scheme_rep_acc()` instead, or apply `.vertical_rep_accumulation.post()`
# function AFTER generating the scheme
vertical_planning(
  reps = c(10, 8, 6),
  reps_change = c(-3, -2, -1, 0),
  step = c(0, 0, 0, 0)
)


# Constant
# ----------------------------------
vertical_constant(c(5, 5, 5), 4)
vertical_constant(c(3, 2, 1), 2)

plot_vertical(vertical_constant)

# Linear
# ----------------------------------
vertical_linear(c(10, 8, 6), c(0, -2, -4))
vertical_linear(c(5, 5, 5), c(0, -1, -2, -3))

plot_vertical(vertical_linear)

# Reverse Linear
# ----------------------------------
vertical_linear_reverse(c(6, 4, 2), c(0, 1, 2))
vertical_linear_reverse(c(5, 5, 5))

plot_vertical(vertical_linear_reverse)

# Block
# ----------------------------------
vertical_block(c(6, 4, 2))

plot_vertical(vertical_block)

# Block Variant
# ----------------------------------
vertical_block_variant(c(6, 4, 2))

plot_vertical(vertical_block_variant)

# Rep Accumulation
# ----------------------------------
# If used with `scheme_generic()` (or any other `scheme_`) it will provide wrong set and rep scheme.
# Use `scheme_rep_acc()` instead, or apply `.vertical_rep_accumulation.post()`
# function AFTER generating the scheme
vertical_rep_accumulation(c(10, 8, 6))

plot_vertical(vertical_rep_accumulation)

# Set Accumulation
# ----------------------------------
# Default is accumulation of the last set
vertical_set_accumulation(c(3, 2, 1))

# We can have whole sequence being repeated
vertical_set_accumulation(c(3, 2, 1), accumulate_set = 1:3)

# Or we can have accumulation of the individual sets
vertical_set_accumulation(c(3, 2, 1), accumulate_set = 1:3, sequence = FALSE)

# We can also have two or more sequences
vertical_set_accumulation(c(10, 8, 6, 4, 2, 1), accumulate_set = c(1:2, 5:6))

# And also repeat the individual sets
vertical_set_accumulation(
  c(10, 8, 6, 4, 2, 1),
  accumulate_set = c(1:2, 5:6),
  sequence = FALSE
)
plot_vertical(vertical_set_accumulation)

# Reverse Set Accumulation
# ----------------------------------
# Default is accumulation of the last set
vertical_set_accumulation_reverse(c(3, 2, 1))

# We can have whole sequence being repeated
vertical_set_accumulation_reverse(c(3, 2, 1), accumulate_set = 1:3)

# Or we can have accumulation of the individual sets
vertical_set_accumulation_reverse(c(3, 2, 1), accumulate_set = 1:3, sequence = FALSE)

# We can also have two or more sequences
vertical_set_accumulation_reverse(c(10, 8, 6, 4, 2, 1), accumulate_set = c(1:2, 5:6))

# And also repeat the individual sets
vertical_set_accumulation_reverse(
  c(10, 8, 6, 4, 2, 1),
  accumulate_set = c(1:2, 5:6),
  sequence = FALSE
)

plot_vertical(vertical_set_accumulation_reverse)

# Undulating
# ----------------------------------
vertical_undulating(c(8, 6, 4))

# Reverse Undulating
# ----------------------------------
vertical_undulating_reverse(c(8, 6, 4))

# Block Undulating
# ----------------------------------
# This is a combination of Block Variant (undulation in the steps) and
# Undulating (undulation in reps)
vertical_block_undulating(c(8, 6, 4))

# Volume-Intensity
# ----------------------------------
vertical_volume_intensity(c(6, 6, 6))

# Rep Accumulation
# --------------------------
scheme_rep_acc()

# Generate Wave scheme with rep accumulation vertical progression
# This functions doesn't allow you to use different vertical planning
# options
scheme <- scheme_rep_acc(reps = c(10, 8, 6), adjustment = c(-0.1, -0.05, 0))
plot(scheme)

# Other options is to use `.vertical_rep_accumulation.post()` and
# apply it after
# The default vertical progression is `vertical_const()`
scheme <- scheme_wave(reps = c(10, 8, 6), adjustment = c(-0.1, -0.05, 0))

.vertical_rep_accumulation.post(scheme)

# We can also create "undulating" rep decrements
.vertical_rep_accumulation.post(
  scheme,
  rep_decrement = c(-3, -1, -2, 0)
)

# `scheme_rep_acc` will not allow you to generate `scheme_ladder()`
# and `scheme_scheme_light_heavy()`
# You must use `.vertical_rep_accumulation.post()` to do so
scheme <- scheme_ladder()
scheme <- .vertical_rep_accumulation.post(scheme)
plot(scheme)

# Please note that reps < 1 are removed. If you do not want this,
# use `remove_reps = FALSE` parameter
scheme <- scheme_ladder()
scheme <- .vertical_rep_accumulation.post(scheme, remove_reps = FALSE)
plot(scheme)
}
