% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MedianPolishM.default.R
\name{MedianPolishM.default}
\alias{MedianPolishM.default}
\title{Median polish multidimensional.}
\usage{
\method{MedianPolishM}{default}(data, eps = 0.01, maxiter = 10L,
  na.rm = TRUE, ...)
}
\arguments{
\item{data}{object of class array, table or matrix (see details).}

\item{eps}{real number greater than \code{0}, default 0.01. A tolerance for convergence: see Details}

\item{maxiter}{the maximum number of iterations. Default 10.}

\item{na.rm}{logical. If the data contains NA's. Default TRUE.}

\item{\dots}{ignored.}
}
\value{
An object of class medpolish with the following named components in a list:

\item{residuals}{the residuals.}

\item{overall}{the fitted constant term.}

\item{effects}{the fitted every dimensions effects of array multidimensional.}

\item{iter}{number of iterations used in the range maxiter.}
}
\description{
An additive model for multidimensional array is fitted, using Tukey's median polish procedure.
}
\details{
The model fitted is additive \eqn{constant + dim_{1} + dim_{2} + \cdots + dim_{n}}. The algorithm works by alternately removing medians of \eqn{dim_{1}, \cdots, dim_{n}}, and continues until the proportional reduction in the sum of absolute residuals is less than eps or until there have been maxiter iterations. If na.rm is FALSE, the presence of any NA value in x will cause an error, otherwise NA values are ignored. MedianPolishM returns an object of class MedianPolishM (see below). There is a plotting method for this class, \code{\link{plot.MedianPolishM}}.
}
\examples{
A<-MedianPolishM(UCBAdmissions, eps=0.1, maxiter=2, na.rm=TRUE)
plot(A)
}
\references{
Hoaglin, D. C., Mosteller, F., & Tukey, J. W. (Eds.). (2011). \emph{Exploring data tables, trends, and shapes} (Vol. 101). John Wiley & Sons.\href{http://www.wiley.com/WileyCDA/WileyTitle/productCd-047004005X.html}{[link]}
}
