% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coBCreg.R
\name{coBCRegG}
\alias{coBCRegG}
\title{Generic Interface coBCReg model}
\usage{
coBCRegG(
  y,
  gen.learner,
  gen.pred,
  N = 3,
  perc.full = 0.7,
  u = 100,
  max.iter = 50,
  gr = 1
)
}
\arguments{
\item{y}{A vector with the labels of training instances. In this vector the
unlabeled instances are specified with the value \code{NA}.}

\item{gen.learner}{A function for training \code{N} supervised base classifiers.
This function needs two parameters, indexes and cls, where indexes indicates
the instances to use and cls specifies the classes of those instances.}

\item{gen.pred}{A function for predicting the probabilities per classes.
This function must be two parameters, model and indexes, where the model
is a classifier trained with \code{gen.learner} function and
indexes indicates the instances to predict.}

\item{N}{The number of classifiers used as committee members. All these classifiers
are trained using the \code{gen.learner} function. Default is 3.}

\item{perc.full}{A number between 0 and 1. If the percentage
of new labeled examples reaches this value the self-labeling process is stopped.
Default is 0.7.}

\item{u}{Number of unlabeled instances in the pool. Default is 100.}

\item{max.iter}{Maximum number of iterations to execute in the self-labeling process.
Default is 50.}

\item{gr}{growing rate}
}
\description{
coBCReg is based on an
ensemble of N diverse regressors. At each iteration and for each regressor, the
companion committee labels the unlabeled examples then the regressor select
the most informative newly-labeled examples for itself, where the selection confidence
is based on estimating the validation error. The final prediction is the
average of the estimates of the N regressors.
}
\details{
For regression tasks, labeling data is very expensive computationally. Its so slow.
}
\references{
Mohamed Farouk Abdel-Hady, Mohamed Farouk Abdel-Hady and Günther Palm.\cr
\emph{Semi-supervised Learning for Regression with Cotraining by Committee}\cr
Institute of Neural Information Processing
University of Ulm
D-89069 Ulm, Germany
}
