% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satter.R
\name{satter}
\alias{satter}
\title{Satterthwaite Function}
\usage{
satter(MScoeff, MSi, dfi, alpha = 0.05)
}
\arguments{
\item{MScoeff}{coefficients c_1, c_2}

\item{MSi}{mean squared values}

\item{dfi}{degrees of freedom}

\item{alpha}{error probability}
}
\value{
vector with 1. estimate of variance 2. degrees of freedom, 3. lower value of 1-alpha confint
4. upper value of 1-alpha confint
}
\description{
The Satterthwaite function can be used to estimate the magnitude of the variance component (sigma_beta)^2, 
when the random factor has significant main effects.
}
\details{
Note, the output from the \code{satter()} procedure is sigma_beta.
}
\examples{
res <- satter(MScoeff= c(1/4, -1/4)
             , MSi = c(394.9, 73.3)
             , dfi = c(4,3)
             , alpha = 0.1)
}
