% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotData.R
\name{plotData}
\alias{plotData}
\title{Interpolated plot}
\usage{
plotData(
  x,
  y,
  which = 1:2,
  constant = x[which.min(y), ],
  model = buildLOESS,
  modelControl = list(),
  xlab = c("x1", "x2"),
  ylab = "y",
  type = "filled.contour",
  ...
)
}
\arguments{
\item{x}{independent variables, or input variables. this should be a matrix of at least two columns 
and several rows. If more than two columns are present, all will be used for fitting the model.
The parameter \code{which} will determine which of these will be plotted, and the parameter
\code{constant} will determine the values of all parameters that are not varied.}

\item{y}{dependent, or observed output variable to be interpolated/regressed and plotted.}

\item{which}{a vector with two elements, each an integer giving the two independent variables of the plot 
(the integers are indices of the respective data set, i.e., columns of x). All other parameters will be fixed to the best known 
solution, i.e., the one with minimal y-value.}

\item{constant}{a numeric vector that states for each variable a constant value that it will take on
if it is not varied in the plot. This affects the parameters not selected by the \code{which} parameter.
By default, this will be fixed to the best known solution, i.e., the one with minimal y-value, according
to \code{which.min(object$y)}. The length of this numeric vector should be the same as the number of columns in \code{object$x}}

\item{model}{the model building function to be used, by default \code{buildLOESS}.}

\item{modelControl}{control list of the chosen model building function.}

\item{xlab}{a vector of characters, giving the labels for each of the two independent variables}

\item{ylab}{character, the value of the dependent variable predicted by the corresponding model}

\item{type}{string describing the type of the plot:  \code{"filled.contour"} (default), \code{"contour"}, 
\code{"persp"} (perspective), or \code{"persp3d"} plot.
Note that "persp3d" is based on the plotly package and will work in RStudio, but not in the standard RGui.}

\item{...}{additional parameters passed to the \code{contour} or \code{filled.contour} function}
}
\description{
A (filled) contour or perspective plot of a data set with
two independent and one dependent variable. The plot is generated by some 
interpolation or regression model. By default, the \code{loess} function is used.
}
\examples{
## generate random test data
testfun <- function (x) sum(x^2)
set.seed(1)
k <- 30
x <- cbind(runif(k)*15-5,runif(k)*15)
y <- as.matrix(apply(x,1,testfun))
plotData(x,y)
plotData(x,y,type="contour")
plotData(x,y,type="persp")

}
\seealso{
\code{\link{plotFunction}}, \code{\link{plotModel}}
}
