% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutation_count.R
\name{mutation_count}
\alias{mutation_count}
\title{Mutation count}
\usage{
mutation_count(
  mutations,
  start_date,
  end_date = Sys.Date(),
  territorial_changes_only = FALSE
)
}
\arguments{
\item{mutations}{A tibble containing the municipality mutations inventory (see
\code{\link{import_CH_municipality_inventory}})}

\item{start_date}{Date vector (incl)}

\item{end_date}{Date vector (excluded)}

\item{territorial_changes_only}{boolean. FALSE if all mutations should be
considered. TRUE if mutations that have an effect on the municipal
territory only should be considered. FALSE includes name changes, Bezirk
number changes etc.}
}
\value{
A list with 4 elements:
\enumerate{
\item mapped: A tibble with the mapped municipalities
\item unmapped: A tibble with the unmapped municipalities
\item state_old: see above
\item state_new: see above
}
}
\description{
Count number of mutations in a given time period
}
\details{
\strong{Approach}

\enumerate{
\item Download the \href{https://www.bfs.admin.ch/bfsstatic/dam/assets/11467405/master}{Swiss municipality inventory}
\item Import it into R workspace with \code{\link{import_CH_municipality_inventory}}
\item Set the old state and the new state (see example)
\item Get the mapping table with this function
}

\strong{Example Daettwil / Baden}

On 1.1.1962 Daettwil (Bfs Nr. 4025) merged with Baden (Bfs Nr. 4021). 
Let's define \itemize{ \item old_state <- as.Date("1961-01-01") \item
new_state <- as.Date("1963-01-01") \item Result: \tabular{rrrrrr}{
bfs_nr_new \tab name_new \tab bfs_nr_old \tab name_old \cr 4021 \tab Baden \tab 4021 \tab Baden \cr 4021 \tab Baden \tab
4025 \tab Daettwil } }
}
\examples{

mutations <- structure(list(hist_id = c(11227L, 11240L, 13189L),
district_hist_id = c(10025L, 10025L, 10025L),
kanton_abbr = c("AG", "AG", "AG"),
bfs_nr = c(4025L, 4021L, 4021L),
name = c("Daettwil", "Baden", "Baden"),
admission_nr = c(1000L, 1000L, 1004L),
admission_mode = c(20L, 20L, 26L),
admission_date = structure(c(-3653, -3653, -2922),
class = c("Date")),
abolition_nr = c(1004L, 1004L, NA),
abolition_mode = c(29L, 26L, NA),
abolition_date = structure(c(-2923, -2923, NA),
class = c("Date")),
change_date = structure(c(-2923, -2923, -2922), class = c("Date"))),
row.names = c(NA, -3L), class = c("tbl_df", "tbl", "data.frame"))

mapping_object <- map_old_to_new_state(mutations,
as.Date("1961-01-01"), as.Date("1963-01-01"))

}
