% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maf2matrix.R
\name{maf2matrix}
\alias{maf2matrix}
\title{maf2matrix}
\usage{
maf2matrix(maffile, percent = 0.01, nonsynonymous = TRUE)
}
\arguments{
\item{maffile}{The name of mutation annotation file (MAF) format data. It must be an absolute path or the name relatived to the current working directory.}

\item{percent}{A threshold value(one percent as the default value). The genes with a given mutation frequency equal or greater than the threshold value are retained for the following analysis.}

\item{nonsynonymous}{Logical, tell if extract the non-silent somatic mutations (nonsense mutation, missense mutation, frame-shif indels, splice site, nonstop mutation, translation start site, inframe indels).}
}
\value{
A binary mutations matrix, in which 1 represents any mutation occurs in a particular gene in a particular sample, otherwise the element is 0.
}
\description{
Function `maf2matrix` use mutation annotation file (MAF) format data to build a binary mutations matrix.
}
\examples{
#get path of the mutation annotation file.
maf = system.file('extdata', 'example.maf.gz', package = 'SMDIC')

# perform function `maf2matrix`.
mutmatrix.example<-maf2matrix(maf)
}
