% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotClusters}
\alias{plotClusters}
\title{Plot cluster structure}
\usage{
plotClusters(
  x,
  plot_signs = FALSE,
  color_clusters = TRUE,
  include_zeroes = TRUE,
  show_alpha = FALSE,
  alpha_steps = NULL,
  palette = "viridis",
  ...
)
}
\arguments{
\item{x}{an object of class \code{'SLOPE'}}

\item{plot_signs}{logical, indicating whether to plot signs of estimated
coefficients on the plot}

\item{color_clusters}{logical, indicating whether the clusters should have
different colors}

\item{include_zeroes}{logical, indicating whether zero variables should be
plotted. Default to TRUE}

\item{show_alpha}{logical, indicating whether labels with alpha values or
steps in the path should be plotted.}

\item{alpha_steps}{a vector of integer alpha steps to plot. If \code{NULL},
all the steps are plotted.}

\item{palette}{a character string specifying the color palette to use for
the clusters. This is passed to \code{\link[grDevices:palettes]{grDevices::hcl.colors()}}.}

\item{...}{additional arguments passed to \code{\link[graphics:image]{graphics::image()}}.}
}
\value{
Invisibly returns NULL. The function is called for its
side effect of producing a plot.
}
\description{
Note that this function requires the \code{patterns} argument to be set to
\code{TRUE} in the call to \code{\link[=SLOPE]{SLOPE()}}. Calling this function on a
\code{SLOPE} object without patterns will result in an error.
}
\examples{
set.seed(10)
X <- matrix(rnorm(10000), ncol = 10)
colnames(X) <- paste0("X", 1:10)
beta <- c(rep(10, 3), rep(-20, 2), rep(20, 2), rep(0, 3))
Y <- X \%*\% beta + rnorm(1000)
fit <- SLOPE(X, Y, patterns = TRUE)

plotClusters(fit)
plotClusters(fit, alpha_steps = 1:10)
}
\seealso{
\code{\link[=SLOPE]{SLOPE()}}, \code{\link[graphics:image]{graphics::image()}}, \code{\link[graphics:text]{graphics::text()}}.
}
