// Generated by rstantools.  Do not edit by hand.

/*
    SLGP is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SLGP is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SLGP.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_likelihoodComposed_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 56> locations_array__ =
  {" (found before start of program)",
  " (in 'string', line 52, column 2 to column 20)",
  " (in 'string', line 56, column 2 to column 40)",
  " (in 'string', line 58, column 2 to column 150)",
  " (in 'string', line 38, column 2 to column 17)",
  " (in 'string', line 39, column 2 to column 25)",
  " (in 'string', line 40, column 2 to column 27)",
  " (in 'string', line 41, column 2 to column 22)",
  " (in 'string', line 42, column 2 to column 17)",
  " (in 'string', line 43, column 9 to column 30)",
  " (in 'string', line 43, column 32 to column 33)",
  " (in 'string', line 43, column 2 to column 50)",
  " (in 'string', line 44, column 9 to column 10)",
  " (in 'string', line 44, column 12 to column 18)",
  " (in 'string', line 44, column 2 to column 33)",
  " (in 'string', line 45, column 16 to column 17)",
  " (in 'string', line 45, column 19 to column 25)",
  " (in 'string', line 45, column 2 to column 27)",
  " (in 'string', line 46, column 9 to column 18)",
  " (in 'string', line 46, column 2 to column 37)",
  " (in 'string', line 47, column 9 to column 10)",
  " (in 'string', line 47, column 12 to column 13)",
  " (in 'string', line 47, column 2 to column 21)",
  " (in 'string', line 48, column 9 to column 10)",
  " (in 'string', line 48, column 2 to column 19)",
  " (in 'string', line 49, column 9 to column 30)",
  " (in 'string', line 49, column 2 to column 44)",
  " (in 'string', line 52, column 9 to column 10)",
  " (in 'string', line 12, column 11 to column 31)",
  " (in 'string', line 12, column 4 to column 76)",
  " (in 'string', line 13, column 11 to column 31)",
  " (in 'string', line 13, column 4 to column 38)",
  " (in 'string', line 15, column 6 to column 42)",
  " (in 'string', line 16, column 6 to column 48)",
  " (in 'string', line 17, column 13 to column 22)",
  " (in 'string', line 17, column 6 to column 64)",
  " (in 'string', line 18, column 6 to column 34)",
  " (in 'string', line 19, column 6 to column 40)",
  " (in 'string', line 20, column 6 to column 67)",
  " (in 'string', line 22, column 8 to column 52)",
  " (in 'string', line 21, column 28 to line 23, column 7)",
  " (in 'string', line 21, column 6 to line 23, column 7)",
  " (in 'string', line 14, column 29 to line 24, column 5)",
  " (in 'string', line 14, column 4 to line 24, column 5)",
  " (in 'string', line 25, column 11 to column 12)",
  " (in 'string', line 25, column 4 to column 27)",
  " (in 'string', line 26, column 4 to column 12)",
  " (in 'string', line 28, column 6 to column 25)",
  " (in 'string', line 30, column 8 to column 30)",
  " (in 'string', line 31, column 8 to column 74)",
  " (in 'string', line 29, column 37 to line 32, column 7)",
  " (in 'string', line 29, column 6 to line 32, column 7)",
  " (in 'string', line 27, column 18 to line 33, column 5)",
  " (in 'string', line 27, column 4 to line 33, column 5)",
  " (in 'string', line 34, column 4 to column 34)",
  " (in 'string', line 11, column 22 to line 35, column 3)"};
template <bool propto__, typename T0__, typename T5__, typename T6__,
          typename T8__, typename T9__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_eigen_matrix_dynamic<T5__>,
                              stan::is_vt_not_complex<T5__>,
                              stan::is_eigen_matrix_dynamic<T6__>,
                              stan::is_vt_not_complex<T6__>,
                              stan::is_col_vector<T8__>,
                              stan::is_vt_not_complex<T8__>,
                              stan::is_col_vector<T9__>,
                              stan::is_vt_not_complex<T9__>>* = nullptr>
stan::promote_args_t<stan::base_type_t<T0__>, stan::base_type_t<T5__>,
  stan::base_type_t<T6__>, stan::base_type_t<T8__>, stan::base_type_t<T9__>>
custom_composed_lpdf(const T0__& epsilon_arg__, const int& n, const int&
                     nIntegral, const int& nPredictors, const int& nNeigh,
                     const T5__& functionValues_arg__, const T6__&
                     weightMatrix_arg__, const std::vector<std::vector<int>>&
                     indMatrix, const T8__& weightQuadrature_arg__,
                     const T9__& trendValues_arg__, std::ostream* pstream__);
template <bool propto__, typename T0__, typename T5__, typename T6__,
          typename T8__, typename T9__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_eigen_matrix_dynamic<T5__>,
                              stan::is_vt_not_complex<T5__>,
                              stan::is_eigen_matrix_dynamic<T6__>,
                              stan::is_vt_not_complex<T6__>,
                              stan::is_col_vector<T8__>,
                              stan::is_vt_not_complex<T8__>,
                              stan::is_col_vector<T9__>,
                              stan::is_vt_not_complex<T9__>>*>
stan::promote_args_t<stan::base_type_t<T0__>, stan::base_type_t<T5__>,
  stan::base_type_t<T6__>, stan::base_type_t<T8__>, stan::base_type_t<T9__>>
custom_composed_lpdf(const T0__& epsilon_arg__, const int& n, const int&
                     nIntegral, const int& nPredictors, const int& nNeigh,
                     const T5__& functionValues_arg__, const T6__&
                     weightMatrix_arg__, const std::vector<std::vector<int>>&
                     indMatrix, const T8__& weightQuadrature_arg__,
                     const T9__& trendValues_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             stan::base_type_t<T5__>,
                             stan::base_type_t<T6__>,
                             stan::base_type_t<T8__>,
                             stan::base_type_t<T9__>>;
  int current_statement__ = 0;
  const auto& epsilon = stan::math::to_ref(epsilon_arg__);
  const auto& functionValues = stan::math::to_ref(functionValues_arg__);
  const auto& weightMatrix = stan::math::to_ref(weightMatrix_arg__);
  const auto& weightQuadrature = stan::math::to_ref(weightQuadrature_arg__);
  const auto& trendValues = stan::math::to_ref(trendValues_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 28;
    stan::math::validate_non_negative_index("Z", "rows(functionValues)",
      stan::math::rows(functionValues));
    Eigen::Matrix<local_scalar_t__,-1,1> Z =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(stan::math::rows(
                                                       functionValues),
        DUMMY_VAR__);
    current_statement__ = 29;
    stan::model::assign(Z,
      stan::math::add(stan::math::multiply(functionValues, epsilon),
        trendValues), "assigning variable Z");
    current_statement__ = 30;
    stan::math::validate_non_negative_index("SLGP", "rows(functionValues)",
      stan::math::rows(functionValues));
    Eigen::Matrix<local_scalar_t__,-1,1> SLGP =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(stan::math::rows(
                                                       functionValues),
        DUMMY_VAR__);
    current_statement__ = 43;
    for (int i = 1; i <= nPredictors; ++i) {
      int start = std::numeric_limits<int>::min();
      current_statement__ = 32;
      start = (1 + ((i - 1) * nIntegral));
      int end = std::numeric_limits<int>::min();
      current_statement__ = 33;
      end = (nIntegral + ((i - 1) * nIntegral));
      current_statement__ = 34;
      stan::math::validate_non_negative_index("segmentZ", "nIntegral",
        nIntegral);
      Eigen::Matrix<local_scalar_t__,-1,1> segmentZ =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(nIntegral,
          DUMMY_VAR__);
      current_statement__ = 35;
      stan::model::assign(segmentZ, stan::math::segment(Z, start, nIntegral),
        "assigning variable segmentZ");
      local_scalar_t__ maxVal = DUMMY_VAR__;
      current_statement__ = 36;
      maxVal = stan::math::max(segmentZ);
      current_statement__ = 37;
      stan::model::assign(segmentZ,
        stan::math::exp(
          stan::math::subtract(stan::model::deep_copy(segmentZ), maxVal)),
        "assigning variable segmentZ");
      local_scalar_t__ integralValue = DUMMY_VAR__;
      current_statement__ = 38;
      integralValue = stan::math::dot_product(segmentZ, weightQuadrature);
      current_statement__ = 41;
      for (int j = 1; j <= nIntegral; ++j) {
        current_statement__ = 39;
        stan::model::assign(SLGP,
          (stan::model::rvalue(segmentZ, "segmentZ",
             stan::model::index_uni(j)) / integralValue),
          "assigning variable SLGP",
          stan::model::index_uni(((start + j) - 1)));
      }
    }
    current_statement__ = 44;
    stan::math::validate_non_negative_index("SLGPcombined", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> SLGPcombined =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    int ind = std::numeric_limits<int>::min();
    current_statement__ = 53;
    for (int i = 1; i <= n; ++i) {
      current_statement__ = 47;
      stan::model::assign(SLGPcombined, 0, "assigning variable SLGPcombined",
        stan::model::index_uni(i));
      current_statement__ = 51;
      for (int j = 1; j <= stan::math::cols(weightMatrix); ++j) {
        current_statement__ = 48;
        ind = stan::model::rvalue(
                stan::model::rvalue(indMatrix, "indMatrix",
                  stan::model::index_uni(i)), "indMatrix[i]",
                stan::model::index_uni(j));
        current_statement__ = 49;
        stan::model::assign(SLGPcombined,
          (stan::model::rvalue(SLGPcombined, "SLGPcombined",
             stan::model::index_uni(i)) +
          (stan::model::rvalue(SLGP, "SLGP", stan::model::index_uni(ind)) *
          stan::model::rvalue(
            stan::model::rvalue(weightMatrix, "weightMatrix",
              stan::model::index_uni(i)), "weightMatrix[i]",
            stan::model::index_uni(j)))), "assigning variable SLGPcombined",
          stan::model::index_uni(i));
      }
    }
    current_statement__ = 54;
    return stan::math::sum(stan::math::log(SLGPcombined));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_likelihoodComposed final : public model_base_crtp<model_likelihoodComposed> {
private:
  int n;
  int nIntegral;
  int nPredictors;
  int nNeigh;
  int p;
  Eigen::Matrix<double,-1,-1> functionValues_data__;
  Eigen::Matrix<double,-1,-1> weightMatrix_data__;
  std::vector<std::vector<int>> indMatrix;
  Eigen::Matrix<double,-1,1> weightQuadrature_data__;
  Eigen::Matrix<double,-1,-1> Sigma_data__;
  Eigen::Matrix<double,-1,1> mean_x_data__;
  Eigen::Matrix<double,-1,1> trendValues_data__;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> functionValues{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> weightMatrix{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> weightQuadrature{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> Sigma{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> mean_x{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> trendValues{nullptr, 0};
public:
  ~model_likelihoodComposed() {}
  model_likelihoodComposed(stan::io::var_context& context__, unsigned int
                           random_seed__ = 0, std::ostream*
                           pstream__ = nullptr) : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_likelihoodComposed_namespace::model_likelihoodComposed";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 4;
      context__.validate_dims("data initialization", "n", "int",
        std::vector<size_t>{});
      n = std::numeric_limits<int>::min();
      current_statement__ = 4;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 4;
      stan::math::check_greater_or_equal(function__, "n", n, 1);
      current_statement__ = 5;
      context__.validate_dims("data initialization", "nIntegral", "int",
        std::vector<size_t>{});
      nIntegral = std::numeric_limits<int>::min();
      current_statement__ = 5;
      nIntegral = context__.vals_i("nIntegral")[(1 - 1)];
      current_statement__ = 5;
      stan::math::check_greater_or_equal(function__, "nIntegral", nIntegral,
        1);
      current_statement__ = 6;
      context__.validate_dims("data initialization", "nPredictors", "int",
        std::vector<size_t>{});
      nPredictors = std::numeric_limits<int>::min();
      current_statement__ = 6;
      nPredictors = context__.vals_i("nPredictors")[(1 - 1)];
      current_statement__ = 6;
      stan::math::check_greater_or_equal(function__, "nPredictors",
        nPredictors, 1);
      current_statement__ = 7;
      context__.validate_dims("data initialization", "nNeigh", "int",
        std::vector<size_t>{});
      nNeigh = std::numeric_limits<int>::min();
      current_statement__ = 7;
      nNeigh = context__.vals_i("nNeigh")[(1 - 1)];
      current_statement__ = 7;
      stan::math::check_greater_or_equal(function__, "nNeigh", nNeigh, 1);
      current_statement__ = 8;
      context__.validate_dims("data initialization", "p", "int",
        std::vector<size_t>{});
      p = std::numeric_limits<int>::min();
      current_statement__ = 8;
      p = context__.vals_i("p")[(1 - 1)];
      current_statement__ = 8;
      stan::math::check_greater_or_equal(function__, "p", p, 1);
      current_statement__ = 9;
      stan::math::validate_non_negative_index("functionValues",
        "nIntegral * nPredictors", (nIntegral * nPredictors));
      current_statement__ = 10;
      stan::math::validate_non_negative_index("functionValues", "p", p);
      current_statement__ = 11;
      context__.validate_dims("data initialization", "functionValues",
        "double",
        std::vector<size_t>{static_cast<size_t>((nIntegral * nPredictors)),
          static_cast<size_t>(p)});
      functionValues_data__ = Eigen::Matrix<double,-1,-1>::Constant((nIntegral
                                * nPredictors), p,
                                std::numeric_limits<double>::quiet_NaN());
      new (&functionValues)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(functionValues_data__.data(),
        (nIntegral * nPredictors), p);
      {
        std::vector<local_scalar_t__> functionValues_flat__;
        current_statement__ = 11;
        functionValues_flat__ = context__.vals_r("functionValues");
        current_statement__ = 11;
        pos__ = 1;
        current_statement__ = 11;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 11;
          for (int sym2__ = 1; sym2__ <= (nIntegral * nPredictors); ++sym2__) {
            current_statement__ = 11;
            stan::model::assign(functionValues, functionValues_flat__[(pos__
              - 1)], "assigning variable functionValues",
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
            current_statement__ = 11;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 12;
      stan::math::validate_non_negative_index("weightMatrix", "n", n);
      current_statement__ = 13;
      stan::math::validate_non_negative_index("weightMatrix", "nNeigh",
        nNeigh);
      current_statement__ = 14;
      context__.validate_dims("data initialization", "weightMatrix",
        "double",
        std::vector<size_t>{static_cast<size_t>(n),
          static_cast<size_t>(nNeigh)});
      weightMatrix_data__ = Eigen::Matrix<double,-1,-1>::Constant(n, nNeigh,
                              std::numeric_limits<double>::quiet_NaN());
      new (&weightMatrix)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(weightMatrix_data__.data(),
        n, nNeigh);
      {
        std::vector<local_scalar_t__> weightMatrix_flat__;
        current_statement__ = 14;
        weightMatrix_flat__ = context__.vals_r("weightMatrix");
        current_statement__ = 14;
        pos__ = 1;
        current_statement__ = 14;
        for (int sym1__ = 1; sym1__ <= nNeigh; ++sym1__) {
          current_statement__ = 14;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 14;
            stan::model::assign(weightMatrix, weightMatrix_flat__[(pos__ -
              1)], "assigning variable weightMatrix",
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
            current_statement__ = 14;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 15;
      stan::math::validate_non_negative_index("indMatrix", "n", n);
      current_statement__ = 16;
      stan::math::validate_non_negative_index("indMatrix", "nNeigh", nNeigh);
      current_statement__ = 17;
      context__.validate_dims("data initialization", "indMatrix", "int",
        std::vector<size_t>{static_cast<size_t>(n),
          static_cast<size_t>(nNeigh)});
      indMatrix = std::vector<std::vector<int>>(n,
                    std::vector<int>(nNeigh, std::numeric_limits<int>::min()));
      {
        std::vector<int> indMatrix_flat__;
        current_statement__ = 17;
        indMatrix_flat__ = context__.vals_i("indMatrix");
        current_statement__ = 17;
        pos__ = 1;
        current_statement__ = 17;
        for (int sym1__ = 1; sym1__ <= nNeigh; ++sym1__) {
          current_statement__ = 17;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 17;
            stan::model::assign(indMatrix, indMatrix_flat__[(pos__ - 1)],
              "assigning variable indMatrix", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 17;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 18;
      stan::math::validate_non_negative_index("weightQuadrature",
        "nIntegral", nIntegral);
      current_statement__ = 19;
      context__.validate_dims("data initialization", "weightQuadrature",
        "double", std::vector<size_t>{static_cast<size_t>(nIntegral)});
      weightQuadrature_data__ = Eigen::Matrix<double,-1,1>::Constant(nIntegral,
                                  std::numeric_limits<double>::quiet_NaN());
      new (&weightQuadrature)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(weightQuadrature_data__.data(),
        nIntegral);
      {
        std::vector<local_scalar_t__> weightQuadrature_flat__;
        current_statement__ = 19;
        weightQuadrature_flat__ = context__.vals_r("weightQuadrature");
        current_statement__ = 19;
        pos__ = 1;
        current_statement__ = 19;
        for (int sym1__ = 1; sym1__ <= nIntegral; ++sym1__) {
          current_statement__ = 19;
          stan::model::assign(weightQuadrature,
            weightQuadrature_flat__[(pos__ - 1)],
            "assigning variable weightQuadrature",
            stan::model::index_uni(sym1__));
          current_statement__ = 19;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 20;
      stan::math::validate_non_negative_index("Sigma", "p", p);
      current_statement__ = 21;
      stan::math::validate_non_negative_index("Sigma", "p", p);
      current_statement__ = 22;
      context__.validate_dims("data initialization", "Sigma", "double",
        std::vector<size_t>{static_cast<size_t>(p), static_cast<size_t>(p)});
      Sigma_data__ = Eigen::Matrix<double,-1,-1>::Constant(p, p,
                       std::numeric_limits<double>::quiet_NaN());
      new (&Sigma)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(Sigma_data__.data(), p, p);
      {
        std::vector<local_scalar_t__> Sigma_flat__;
        current_statement__ = 22;
        Sigma_flat__ = context__.vals_r("Sigma");
        current_statement__ = 22;
        pos__ = 1;
        current_statement__ = 22;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 22;
          for (int sym2__ = 1; sym2__ <= p; ++sym2__) {
            current_statement__ = 22;
            stan::model::assign(Sigma, Sigma_flat__[(pos__ - 1)],
              "assigning variable Sigma", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 22;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 23;
      stan::math::validate_non_negative_index("mean_x", "p", p);
      current_statement__ = 24;
      context__.validate_dims("data initialization", "mean_x", "double",
        std::vector<size_t>{static_cast<size_t>(p)});
      mean_x_data__ = Eigen::Matrix<double,-1,1>::Constant(p,
                        std::numeric_limits<double>::quiet_NaN());
      new (&mean_x)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(mean_x_data__.data(), p);
      {
        std::vector<local_scalar_t__> mean_x_flat__;
        current_statement__ = 24;
        mean_x_flat__ = context__.vals_r("mean_x");
        current_statement__ = 24;
        pos__ = 1;
        current_statement__ = 24;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 24;
          stan::model::assign(mean_x, mean_x_flat__[(pos__ - 1)],
            "assigning variable mean_x", stan::model::index_uni(sym1__));
          current_statement__ = 24;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 25;
      stan::math::validate_non_negative_index("trendValues",
        "nIntegral * nPredictors", (nIntegral * nPredictors));
      current_statement__ = 26;
      context__.validate_dims("data initialization", "trendValues", "double",
        std::vector<size_t>{static_cast<size_t>((nIntegral * nPredictors))});
      trendValues_data__ = Eigen::Matrix<double,-1,1>::Constant((nIntegral *
                             nPredictors),
                             std::numeric_limits<double>::quiet_NaN());
      new (&trendValues)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(trendValues_data__.data(),
        (nIntegral * nPredictors));
      {
        std::vector<local_scalar_t__> trendValues_flat__;
        current_statement__ = 26;
        trendValues_flat__ = context__.vals_r("trendValues");
        current_statement__ = 26;
        pos__ = 1;
        current_statement__ = 26;
        for (int sym1__ = 1; sym1__ <= (nIntegral * nPredictors); ++sym1__) {
          current_statement__ = 26;
          stan::model::assign(trendValues, trendValues_flat__[(pos__ - 1)],
            "assigning variable trendValues", stan::model::index_uni(sym1__));
          current_statement__ = 26;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 27;
      stan::math::validate_non_negative_index("epsilon", "p", p);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = p;
  }
  inline std::string model_name() const final {
    return "model_likelihoodComposed";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_likelihoodComposed_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> epsilon =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 1;
      epsilon = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(p);
      {
        current_statement__ = 2;
        lp_accum__.add(stan::math::multi_normal_lpdf<propto__>(epsilon,
                         mean_x, Sigma));
        current_statement__ = 3;
        lp_accum__.add(custom_composed_lpdf<false>(epsilon, n, nIntegral,
                         nPredictors, nNeigh, functionValues, weightMatrix,
                         indMatrix, weightQuadrature, trendValues, pstream__));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_likelihoodComposed_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> epsilon =
        Eigen::Matrix<double,-1,1>::Constant(p,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      epsilon = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(p);
      out__.write(epsilon);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> epsilon =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(epsilon,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(p),
        "assigning variable epsilon");
      out__.write(epsilon);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "epsilon",
        "double", std::vector<size_t>{static_cast<size_t>(p)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> epsilon =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> epsilon_flat__;
        current_statement__ = 1;
        epsilon_flat__ = context__.vals_r("epsilon");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(epsilon, epsilon_flat__[(pos__ - 1)],
            "assigning variable epsilon", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(epsilon);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"epsilon"};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(p)}};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      param_names__.emplace_back(std::string() + "epsilon" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      param_names__.emplace_back(std::string() + "epsilon" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"epsilon\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"parameters\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"epsilon\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"parameters\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = p;
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = p;
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_likelihoodComposed_namespace::model_likelihoodComposed;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_likelihoodComposed_namespace::profiles__;
}
#endif
#endif
