% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.SLCARE}
\alias{plot.SLCARE}
\title{Produce Plots for SLCARE}
\usage{
\method{plot}{SLCARE}(x, type = c("ModelChecking", "mu0", "EstMeans"), ...)
}
\arguments{
\item{x}{an object of class \code{SLCARE}.}

\item{type}{the type of the plot.}

\item{...}{other arguments.}
}
\value{
A \code{ggplot} object.
}
\description{
Generate cumulative baseline intensity function, estimated mean function, model checking plot for SLCARE.
}
\details{
\code{SLCARE} provides visualization tools to depict the estimated functional model parameters and related functional quantities of interest.
These tools include:

\bold{mu0:} estimated cumulative baseline intensity function.

\bold{EstMeans:} estimated mean function plot - The crude estimates for the class-specific mean functions of recurrent events

\code{SLCARE} also provides a tool to help assess the adequacy of the fitted model:

\bold{ModelChecking:} model checking plot - A plot shows the comparison of the observed recurrent events versus the expected number of recurrent events. A major departure from the identity line may suggest a lack-of-fit of the assumed models.
}
\seealso{
\code{\link[=SLCARE]{SLCARE()}}
}
