% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawcoef.R
\name{draw.coef}
\alias{draw.coef}
\title{Random Draw of Coefficients for AR Models and MA Models}
\usage{
draw.coef(deg, delta = 0.02)
}
\arguments{
\item{deg}{Degree of the polynomial. Maximum degree is 5.}

\item{delta}{The minimum distance of a polynomial root from the boundary 1 or -1. The default is 0.02.}
}
\value{
\eqn{c = (c1,c2,...)} denotes the coefficients of \eqn{1-c1*x-c2*x^2-...}.
}
\description{
Random draw of polynomial coefficients for stationary AR models or invertible MA models.
The resulting polynomial has solutions outside the unit circle.
}
\examples{
draw.coef(2)
}
