% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSA_cat.R
\name{SSA.cat}
\alias{SSA.cat}
\title{Estimation of single catalytic constant using the stochastic simulation approximation method}
\usage{
SSA.cat(method = T, time, species, enz, subs, MM, catal,
  nrepeat = 10000, jump = 1, burning = 0, catal_m = 1,
  catal_v = 1e+06)
}
\arguments{
\item{method}{method selection: T=TQ model, F=SQ model(default = T)}

\item{time}{observed time interval}

\item{species}{observed trajectory of product}

\item{enz}{enzyme concentration}

\item{subs}{substrate concentration}

\item{MM}{true value of MM constant}

\item{catal}{initial value of catalytic constant}

\item{nrepeat}{total number of iteration (default=10000)}

\item{jump}{length of distance (default =1)}

\item{burning}{lenth of burning period (default =0)}

\item{catal_m}{prior mean of gamma prior (default =1)}

\item{catal_v}{prior variance of gamma prior (default =1e+6)}
}
\value{
A vector of posterior samples of catalytic constant
}
\description{
The function estimates single catalytic constant using single data set with an initial
enzyme concentrations and substrate concentration. The stochastic simulation approximation
method is utilized for the likelihood function.
}
\details{
The function SSA.cat generates a set of Monte Carlo simulation samples from
the conditional posterior distribution of catalytic constant of enzyme kinetics model.
As the catalytic constant is only parameter to be estimated in the function the user
should assign MM constant as well as initial enzyme concentration and substrate
concentration. The prior information for the parameter can be given.
}
\examples{
data("Chymo_low")
time1=Chymo_low[,1]
species1=Chymo_low[,2]
Chymotrypsin.low<-SSA.cat(method=TRUE,time=time1,species=species1,enz=4.4e+7,subs=4.4e+7
                 ,MM=4.4e+8, catal=0.1,nrepeat = 10000)
}
