% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_codes.R
\name{get_shark_codes}
\alias{get_shark_codes}
\title{Get SHARK codelist from SMHI}
\usage{
get_shark_codes(
  url =
    "https://smhi.se/oceanografi/oce_info_data/shark_web/downloads/codelist_SMHI.xlsx",
  sheet = 1,
  skip = 1,
  force = FALSE,
  clean_cache_days = 30
)
}
\arguments{
\item{url}{Character string with the URL to the SHARK codes Excel file.
Defaults to the official SMHI codelist.}

\item{sheet}{Sheet to read. Can be either the sheet name or its index
(default is \code{1}).}

\item{skip}{Number of rows to skip before reading data
(default is \code{1}, to skip the header row).}

\item{force}{Logical; if \code{TRUE}, forces re-download of the Excel file
even if a cached copy is available. Default is \code{FALSE}.}

\item{clean_cache_days}{Numeric; if not \code{NULL}, cached SHARK code Excel files older than
this number of days will be automatically deleted. Defaults to 30. Set to \code{NULL}
to disable automatic cleanup.}
}
\value{
A \code{tibble} containing the contents of the requested sheet.
}
\description{
This function downloads the SHARK codes Excel file from SMHI (if not already cached)
and reads it into R. The file is stored in a persistent cache directory
so it does not need to be downloaded again in subsequent sessions.
}
\examples{
\donttest{
  # Read the first sheet, skipping the first row
  codes <- get_shark_codes()
  head(codes)

  # Force re-download of the Excel file
  codes <- get_shark_codes(force = TRUE)
}
}
\seealso{
\code{\link[=clean_shark4r_cache]{clean_shark4r_cache()}} to manually clear cached files.
}
