% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SESraster.R
\name{algorithm_metrics}
\alias{algorithm_metrics}
\title{Performance of randomization algorithms}
\usage{
algorithm_metrics(
  x,
  spat_alg = NULL,
  spat_alg_args = NULL,
  aleats = 10,
  filename = "",
  force_wr_aleat_file = FALSE,
  ...
)
}
\arguments{
\item{x}{SpatRaster. A SpatRaster containing presence-absence data (0 or 1)
for a set of species.}

\item{spat_alg}{A function with the algorithm implementing the desired
randomization method. It must work with SpatRaster objects. See examples.
Example of functions that work are: \code{\link{bootspat_naive}},
\code{\link{bootspat_str}}, \code{\link{bootspat_ff}}.}

\item{spat_alg_args}{List of arguments passed to the randomization method
chosen in 'spat_alg'. See \code{\link{bootspat_naive}}, \code{\link{bootspat_str}},
\code{\link{bootspat_ff}}}

\item{aleats}{positive integer. A positive integer indicating how many times
the calculation should be repeated.}

\item{filename}{character. Output filename}

\item{force_wr_aleat_file}{logical. Force writing bootstrapped rasters, even if
files fit in memory. Mostly used for internal test units.}

\item{...}{additional arguments passed to 'terra::app()' function.}
}
\value{
a list with two components:
\itemize{
\item{spp_metrics: a matrix with metrics comparing actual and randomized frequency
of species occurrence. Metrics are average, sd, min, and max frequency across
randomizations, sp_reldiff (average difference relative to species frequency),
global_reldiff (average difference relative to the number of available cells),
upper and lower confidence intervals for sp_reldiff and global_reldiff.}
\item{spat_rich_diff: a SpatRaster with summary statistics about differences
between actual and bootstrapped site (cell) richness}
}
}
\description{
Compares the richness and occurrence incidence across species
between actual and randomized species distributions
}
\examples{
library(SESraster)
library(terra)
r <- load_ext_data()
algorithm_metrics(r, spat_alg = "bootspat_naive", spat_alg_args=list(random="species"), aleats = 3)
algorithm_metrics(r, spat_alg = "bootspat_naive", spat_alg_args=list(random="site"), aleats = 3)
# algorithm_metrics(r, spat_alg = "bootspat_naive", spat_alg_args=list(random="both"))

}
\seealso{
\code{\link{bootspat_str}}, \code{\link{bootspat_naive}},
\code{\link{bootspat_ff}}, \code{\link{SESraster}}, \code{\link{plot_alg_metrics}}
}
\author{
Neander M. Heming
}
