% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.sens.pars.R
\name{gen.sens.pars}
\alias{gen.sens.pars}
\title{Generate Sensitivity Parameters}
\usage{
gen.sens.pars(dist.mean, dist.rank, n.of.ants, nl, q = 1e-04, k = 50, xi = 0.5)
}
\arguments{
\item{dist.mean}{List of means - coordinates}

\item{dist.rank}{Rank of the archived values of optimization object}

\item{n.of.ants}{Number of ants used in each iteration after the initialization
of k length, default value is 10.}

\item{nl}{Neighborhood of the search area}

\item{q}{Locality of the search (0,1), default is 0.0001}

\item{k}{Size of the solution archive, default is 50.}

\item{xi}{Convergence pressure (0,Inf), suggested: (0,1), default is 0.5}
}
\value{
Generated sensitivity parameter values (i.e., a matrix with n.of.ants
    rows and n.of.sens.pars columns)
}
\description{
This function can generate a set of path coefficients from
    a phantom variable to variables in a structural equation model
    based on given distributions of the rank of optimization target
    (with probability of using a distribution based on its rank).
}
\examples{

k <- 50 # size of archive
# Generate dist.mean and dist.rank
dist.mean <- cbind(rnorm(k), rnorm(k), rnorm(k), rnorm(k), rnorm(k))
y <- rowMeans(dist.mean)
dist.rank <- rank(-y, ties.method = "random")
# set up neighborhood
nl <- matrix(NA, k, k-1)
for (i in 1:k){
  nl[i,] <- (1:k)[1:k != i]
 }
my.sens.pars <- gen.sens.pars(dist.mean, dist.rank, n.of.ants = 10,
                              nl, q = 0.0001, k =50, xi = 0.50)
my.sens.pars

}
\references{
Socha, K., & Dorigo, M. (2008). Ant colony optimization for
  continuous domains. European Journal of Operational Research,
  185(3), 1155-1173.

  We thank Dr. Krzysztof Socha for providing us the
  original code (http://iridia.ulb.ac.be/supp/IridiaSupp2008-001/)
  for this function.
}
