% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semUtils.R
\name{colorGraph}
\alias{colorGraph}
\title{Vertex and edge graph coloring on the base of fitting}
\usage{
colorGraph(
  est,
  graph,
  group,
  method = "none",
  alpha = 0.05,
  vcolor = c("lightblue", "white", "pink"),
  ecolor = c("royalblue3", "gray50", "red2"),
  ewidth = c(1, 2),
  ...
)
}
\arguments{
\item{est}{A data.frame of estimated parameters and p-values, derived
from the \code{fit} object returned by \code{\link[SEMgraph]{SEMrun}}.
As an alternative, the user may provide a "gest" or "dest" data.frame
generated by \code{\link[SEMgraph]{SEMrun}}.}

\item{graph}{An igraph object.}

\item{group}{group A binary vector. This vector must be as long as the
number of subjects. Each vector element must be 1 for cases and 0
for control subjects.}

\item{method}{Multiple testing correction method. One of the values
available in \code{\link[stats]{p.adjust}}. By default, method is set
to "none" (i.e., no multiple test correction).}

\item{alpha}{Significance level for node and edge coloring
(by default, \code{alpha = 0.05}).}

\item{vcolor}{A vector of three color names. The first color is given
to nodes with P-value < alpha and beta < 0, the third color is given
to nodes with P-value < alpha and beta > 0, and the second is given
to nodes with P-value > alpha. By default,
\code{vcolor = c("lightblue", "white", "pink")}.}

\item{ecolor}{A vector of three color names. The first color is given
to edges with P-value < alpha and regression coefficient < 0, the
third color is given to edges with P-value < alpha and regression
coefficient > 0, and the second is given to edges with P-value > alpha.
By default, \code{vcolor = c("blue", "gray50", "red2")}.}

\item{ewidth}{A vector of two values. The first value refers to the
basic edge width (i.e., edges with P-value > alpha), while the second
is given to edges with P-value < alpha. By default ewidth = c(1, 2).}

\item{...}{Currently ignored.}
}
\value{
An igraph object with vertex and edge color and width attributes.
}
\description{
Add vertex and edge color attributes to an igraph object,
based on a fitting results data.frame generated by
\code{\link[SEMgraph]{SEMrun}}.
}
\examples{

\donttest{

# Model fitting: node perturbation
sem1 <- SEMrun(graph = alsData$graph, data = alsData$exprs,
               group = alsData$group,
               fit = 1)
est1 <- parameterEstimates(sem1$fit)

# Model fitting: edge perturbation
sem2 <- SEMrun(graph = alsData$graph, data = alsData$exprs,
               group = alsData$group,
               fit = 2)
est20 <- subset(parameterEstimates(sem2$fit), group == 1)[, -c(4, 5)]
est21 <- subset(parameterEstimates(sem2$fit), group == 2)[, -c(4, 5)]

# Graphs
g <- alsData$graph
x <- alsData$group

old.par <- par(no.readonly = TRUE)
par(mfrow=c(2,2), mar=rep(1,4))
gplot(colorGraph(est = est1, g, group = x, method = "BH"),
      main = "vertex differences")
gplot(colorGraph(est = sem2$dest, g, group = NULL),
      main = "edge differences")
gplot(colorGraph(est = est20, g, group = NULL),
      main = "edges for group = 0")
gplot(colorGraph(est = est21, g, group = NULL),
      main = "edges for group = 1")
par(old.par)

}

}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
