% Generated by roxygen2 (4.0.2): do not edit by hand
\name{madp}
\alias{madp}
\title{Mean Absolute Difference for Pairs}
\usage{
madp(x, g1, g2, f, s)
}
\arguments{
\item{x}{a column vector of scores on which the rsd is conditioned}

\item{g1}{a column vector of equated scores based on a single subpopulation (aligned with elements in x)}

\item{g2}{a column vector of equated scores based on a different single subpopulation (aligned with elements in x)}

\item{f}{a column vector of relative frequency associated with each raw score (can be based on either overall population or a subpopulation) (aligned with elements in x)}

\item{s}{a scalar representing the standard deviation of x for any (sub)population of interest (e.g., synthetic population) (default is 1, which leads to calculation of the unstandardized madp)}
}
\value{
mean absolute difference
}
\description{
The mean absolute difference index, \eqn{MAD}{MAD}, is a summary of the conditional \eqn{AD(x)}{AD(x)} index, specifically the mean of absolute differences at each score level \eqn{x}{x}. Formally,
\deqn{MAD(x)=\frac{\sum_x P_x\mid y_j(x) - y_{j'}(x) \mid}{\sigma_x},}{MAD(x)=sum(P|y_j(x) - y_j'(x)|)/s,}
where \eqn{y_j(x)}{y_j(x)} is an equated score based on subpopulation \eqn{j}{j}, \eqn{y_{j'}(x)}{y_j'(x)} is an equated score based on subpopulation \eqn{j'}{j'}, \eqn{P_x}{P} represents a proportion of examinees based on the population distribution specified in argument \eqn{f}{f}, and \eqn{\sigma_x}{s} is the standard deviation of \eqn{x}{x} scores for the (sub)population of interest. It is considered a pairwise, unconditional invariance method. It was originally presented by Kolen and Brennan (2004). It provides practitioners with a summary of the magnitude of equated score differences between two subpopulations.
}
\note{
The equally weighted version of this index (Kolen & Brennan, 2004) can be obtained by inputting an \eqn{f}{f} vector consisting of identical elements that sum to 1. For example, using f=c(rep(.047619,21)) with the example data set, \code{\link{ex.data}}.
}
\examples{
#Unstandardized MAD for subpopulation 1 and subpopulation 2 in the example data set, ex.data
madp(x=ex.data[,1],g1=ex.data[,3],g2=ex.data[,4],f=ex.data[,8])

#Unstandardized MAD for subpopulation 4 and subpopulation 5 in the example data set, ex.data
madp(x=ex.data[,1],g1=ex.data[,6],g2=ex.data[,7],f=ex.data[,8])

#Standardized MAD for subpopulation 4 and subpopulation 5 in the example data set, ex.data
madp(x=ex.data[,1],g1=ex.data[,6],g2=ex.data[,7],f=ex.data[,8],s=4.2)
}
\author{
Anne Corinne Huggins-Manley
}
\references{
\itemize{
\item{Kolen, M.J., & Brennan, R.L. (2004). Test equating, scaling, and linking: Methods and practices (2nd ed.). NY: Springer.}
}
}
\seealso{
\code{\link{adx}}
}

