% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEcalculation.R
\name{SEcalculation}
\alias{SEcalculation}
\title{Splicing Efficiency Calculation}
\usage{
SEcalculation(BAM_files, Anno_SAF, paired = TRUE, thread = 1, strand = 1)
}
\arguments{
\item{BAM_files}{Aligned reads stored in indexed bam files.(2 bam files)}

\item{Anno_SAF}{Splicing sites annotation in a saf file.}

\item{paired}{Whether the sequencing is paired or not.}

\item{thread}{threads number used in calculating}

\item{strand}{which strand of the sequencing}
}
\value{
a large list
}
\description{
This function is used to calculate the splicing efficiency.
}
\examples{
\donttest{
BAM_files <- c("~/project3tB/SEAA_project/R_counstruction_place/SEAA/inst/extdata/NC_t.bam",
"~/project3tB/SEAA_project/R_counstruction_place/SEAA/inst/extdata/USP_t.bam")
Anno_SAF<-"~/project3tB/SEAA_project/R_counstruction_place/SEAA/inst/extdata/test.saf"
SEresultlist<-SEcalculation(BAM_files,Anno_SAF,paired = TRUE ,thread = 2,strand = 1)
}

}
