% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mNearestN.R
\name{mNearestN}
\alias{mNearestN}
\title{m nearest neighbors based on a distance matrix}
\usage{
mNearestN(distMat, m = 5, listv = FALSE, rn = FALSE)
}
\arguments{
\item{distMat}{distance matrix}

\item{m}{number of nearest neighbors, default value 5}

\item{listv}{logical, default FALSE. If TRUE the list of neighbors should also be returned}

\item{rn}{logical, default FALSE. If TRUE, the spatial weights matrix will be row-normalized}
}
\value{
\item{W}{spatial weights matrix }
\item{nlist}{list of indexes of the m nearest neighbors}
}
\description{
This function finds the m nearest neighbors, given a matrix of distances.
}
\examples{
data(gN3dist, package = "SDPDmod")
fournn <- mNearestN(gN3dist, m = 4)
mat1   <- rownor(fournn)
tennn  <- mNearestN(gN3dist, 10, listv = TRUE, rn = TRUE)
mat2   <- tennn$W

}
\author{
Rozeta Simonovska
}
