% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.SDForest}
\alias{predict.SDForest}
\title{Predictions for the SDForest}
\usage{
\method{predict}{SDForest}(object, newdata, mc.cores = 1, ...)
}
\arguments{
\item{object}{Fitted object of class \code{SDForest}.}

\item{newdata}{New test data of class \code{data.frame} containing
the covariates for which to predict the response.}

\item{mc.cores}{Number of cores to use for parallel processing,
if \code{mc.cores > 1} the trees predict in parallel.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A vector of predictions for the new data.
}
\description{
Predicts the response for new data using a fitted SDForest.
}
\examples{
set.seed(1)
n <- 50
X <- matrix(rnorm(n * 5), nrow = n)
y <- sign(X[, 1]) * 3 + rnorm(n)
model <- SDForest(x = X, y = y, Q_type = 'no_deconfounding', nTree = 5, cp = 0.5)
predict(model, newdata = data.frame(X))
}
\seealso{
\code{\link{SDForest}}
}
\author{
Markus Ulmer
}
