% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dupfilter_qi.R
\name{dupfilter_qi}
\alias{dupfilter_qi}
\title{Filter temporal duplicates by quality index}
\usage{
dupfilter_qi(sdata = sdata, step.time = 0)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "qi". 
The function filters the input data by the unique "id". 
"DateTime" is date & time in class \code{\link[base]{POSIXct}}. 
"qi" is the numerical quality index associated with each location fix where a greater number indicates a higher accuracy 
(e.g. the number of GPS satellites involved in estimation).}

\item{step.time}{Consecutive locations less than or equal to \emph{step.time} apart are considered temporal duplicates.
Default is 0 hours.}
}
\value{
The input data frame is returned with temporal duplicates removed by the quality index.
}
\description{
Function to filter temporal duplicates in tracking data by quality index.
}
\details{
This function is a partial component of \code{\link{dupfilter}}, although works as a stand-alone function. 
It looks for temporal duplicates and retains a fix with the highest quality index.
}
\references{
Shimada T, Limpus C, Jones R, Hazel J, Groom R, Hamann M (2016) 
Sea turtles return home after intentional displacement from coastal foraging areas. 
\emph{Marine Biology} 163:1-14 doi:\href{http://doi.org/10.1007/s00227-015-2771-0}{10.1007/s00227-015-2771-0}
}
\seealso{
\code{\link{dupfilter}}, \code{\link{dupfilter_exact}}, \code{\link{dupfilter_time}}, \code{\link{dupfilter_space}}, \code{\link{track_param}}
}
\author{
Takahiro Shimada
}
