% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspe.test.R
\name{mspe.test}
\alias{mspe.test}
\alias{mspe_test}
\title{Function to compute the post/pre treatment MSPE ratio for the 
    treated unit and placebos}
\usage{
mspe.test(tdf, discard.extreme = FALSE, mspe.limit = 20)

mspe_test(tdf, discard.extreme = FALSE, mspe.limit = 20)
}
\arguments{
\item{tdf}{An object constructed by \code{\link{generate.placebos}}}

\item{discard.extreme}{Logical. Whether or not placebos with high 
pre-treatement MSPE should be excluded from the count and significance 
testing.}

\item{mspe.limit}{Numerical. Used if \code{discard.extreme} is \code{TRUE}. 
It indicates how many times the pretreatment MSPE of a placebo should be 
higher than that of the treated unit to be considered extreme and 
discarded. Default is \code{20}.}
}
\value{
\describe{
   \item{p.val}{The p-value of the treated unit post/pre MSPE ratio. 
   It is the proportion of units (placebos and treated) that have a ratio 
   equal or higher that of the treated unit}
   \item{test}{Dataframe with two columns. The first is the post/pre MSPE 
   ratio for each unit. The second indicates unit names}
}
}
\description{
Computes the post/pre treatement mean square prediction error 
   ratio for a treated unit in a synthetic control analysis and all placebos 
   produced with \code{\link{generate.placebos}}. Returns a matrix with 
   ratios and a p-value of how extreme the treated unit's ratio is in 
   comparison with that of placebos. Equivalent to a significance testing 
   of a synthetic controls result.
}
\details{
Post/pre-treatement mean square prediction error ratio is the 
   difference between the observed outcome of a unit and its synthetic 
   control, before and after treatement. A higher ratio means a small 
   pre-treatment prediction error (a good synthetic control), and a 
   high post-treatment MSPE, meaning a large difference between the unit 
   and its synthetic control after the intervention. 
   By calculating this ratio for all placebos, the test can be interpreted 
   as looking at how likely the result obtained for a single treated case 
   with a synthetic control analysis could have occurred by chance given 
   no treatement. For more detailed description, see Abadie, Diamond, 
   and Hainmueller (2011, 2014).
}
\examples{
\donttest{## Example with toy data from 'Synth'
library(Synth)
# Load the simulated data
data(synth.data)

# Execute dataprep to produce the necessary matrices for 'Synth'
dataprep.out<-
  dataprep(
    foo = synth.data,
    predictors = c("X1"),
    predictors.op = "mean",
    dependent = "Y",
    unit.variable = "unit.num",
    time.variable = "year",
    special.predictors = list(
      list("Y", 1991, "mean")
    ),
    treatment.identifier = 7,
    controls.identifier = c(29, 2, 13, 17),
    time.predictors.prior = c(1984:1989),
    time.optimize.ssr = c(1984:1990),
    unit.names.variable = "name",
    time.plot = 1984:1996
)

# run the synth command to create the synthetic control
synth.out <- synth(dataprep.out, Sigf.ipop=2)

## run the generate.placebos command to reassign treatment status
## to each unit listed as control, one at a time, and generate their
## synthetic versions. Sigf.ipop = 2 for faster computing time. 
## Increase to the default of 5 for better estimates. 
tdf <- generate.placebos(dataprep.out,synth.out, Sigf.ipop = 2)

## Test how extreme was the observed treatment effect given the placebos:
ratio <- mspe.test(tdf)
ratio$p.val

mspe.plot(tdf, discard.extreme = FALSE)
}   
}
\seealso{
\code{\link{generate.placebos}}, \code{\link{mspe.plot}}, 
   \code{\link[Synth]{synth}}
}
