% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_timestamps.R
\name{db_timestamp}
\alias{db_timestamp}
\alias{db_timestamp.default}
\alias{db_timestamp.SQLiteConnection}
\title{Determine the type of timestamps the DB supports}
\usage{
db_timestamp(timestamp, conn)

\method{db_timestamp}{default}(timestamp, conn)

\method{db_timestamp}{SQLiteConnection}(timestamp, conn)
}
\arguments{
\item{timestamp}{The timestamp to be transformed to the DB type. Can be character.}

\item{conn}{A \code{DBIConnection} to the DB where the timestamp should be stored}
}
\value{
The given timestamp converted to a SQL-backend dependent timestamp
}
\description{
Determine the type of timestamps the DB supports
}
\examples{
conn <- get_connection(drv = RSQLite::SQLite())

db_timestamp(Sys.time(), conn)

close_connection(conn)
}
