% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parammod.R
\name{parammod}
\alias{parammod}
\title{Parameter Model}
\usage{
parammod(logd, r, t, invt, loggradt, ...)
}
\arguments{
\item{logd}{\code{function(params)} - log-density function for parameters}

\item{r}{\code{function(kappa)} - random function to draw parameters}

\item{t}{mapping parameter space to real line}

\item{invt}{mapping real line to parameter space}

\item{loggradt}{log of the gradient of mapping \code{t}}

\item{...}{additional arguments to store in the \code{parammod} object}
}
\value{
a \code{parammod} object
}
\description{
create a \code{parammod} object
}
\details{
A parameter model is a probability model for a \code{params} object.
This class creates a closure with five functions:
- a random method for sampling a \code{params} object
- a log-density method for computing the log-density of a given \code{params} object
- a transformation function \code{t} that maps a parameter value to the real line
- the inverse of t
- the log-gradient of t
}
\seealso{
\code{\link{param_beta}} \code{\link{param_gamma}} \code{\link{param_nbin}} \code{\link{param_norm}}
}
