% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parammod.R
\name{param_beta}
\alias{param_beta}
\title{Beta parameter model}
\usage{
param_beta(a0, a1, b0, b1)
}
\arguments{
\item{a0}{\code{theta_0 ~ Beta(a0,a1)}}

\item{a1}{\code{theta_0 ~ Beta(a0,a1)}}

\item{b0}{\code{theta_k ~ Beta(b0,b1)}}

\item{b1}{\code{theta_k ~ Beta(b0,b1)}}
}
\value{
a \code{parammod}
}
\description{
A \code{parammod} with beta-distributed parameters
}
\details{
This model represents a prior on theta with:
\deqn{theta_0 ~ Beta(a0,a1)}
\deqn{theta_k ~ Beta(b0,b1)} for k = 1 ... kappa
}
\examples{
## theta0 ~ Beta(1,9); thetak ~ Beta(9,1)
pb <- param_beta(1,9,9,1)
pb$r(5) ## a draw with 5 within-block parameters
}
