% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.minkowski.R
\name{minkowski}
\alias{minkowski}
\title{Minkowski distance}
\usage{
minkowski(X, Y, p = 2)
}
\arguments{
\item{X}{[matrix or SparseHist] If matrix, dim = ( nrow = n_samples, ncol =
n_features)}

\item{Y}{[matrix or SparseHist] If matrix, dim = ( nrow = n_samples, ncol =
n_features)}

\item{p}{[float] power of distance}
}
\value{
[float] value of distance
}
\description{
Compute Minkowski distance between two dataset or SparseHist X and Y. If
p = 2, it is the Euclidean distance, for p = 1, it is the manhattan distance,
if p = Inf, chebyshev distance is called.
}
\examples{
X = base::cbind( stats::rnorm(2000) , stats::rnorm(2000)  )
Y = base::cbind( stats::rnorm(2000,mean=2)  , stats::rnorm(2000) )
bw = base::c(0.1,0.1)
muX = SBCK::SparseHist( X , bw )
muY = SBCK::SparseHist( Y , bw )

## The four are equals
d = SBCK::minkowski(  X ,   Y , p = 3 )
d = SBCK::minkowski(muX ,   Y , p = 3 )
d = SBCK::minkowski(  X , muY , p = 3 )
d = SBCK::minkowski(muX , muY , p = 3 )

}
