% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCRs.R
\name{HCRlin}
\alias{HCRlin}
\title{Generic linear harvest control rule based on biomass}
\usage{
HCRlin(OCP_val, LOCP, TOCP, relF_min = 0, relF_max = 1)
}
\arguments{
\item{OCP_val}{The value of the operational control point (OCP).}

\item{LOCP}{Numeric, the limit value for the OCP in the HCR.}

\item{TOCP}{Numeric, the target value for the OCP in the HCR.}

\item{relF_min}{The relative maximum value (e.g. a multiple of FMSY) if \code{OCP < LOCP}.}

\item{relF_max}{The relative maximum value (e.g. a multiple of FMSY) if \code{OCP > TOCP}.}
}
\value{
Numeric adjustment factor.
}
\description{
A general function used by \link{HCR_ramp} that adjusts the output (e.g., F) by a linear ramp based on 
the value of the OCP relative to target and limit values.
}
\examples{
#40-10 linear ramp
Brel <- seq(0, 1, length.out = 200)
plot(Brel, HCRlin(Brel, 0.1, 0.4), xlab = "Estimated B/B0", ylab = "Relative change in F",
     main = "A 40-10 harvest control rule", type = 'l', col = 'blue')
abline(v = c(0.1,0.4), col = 'red', lty = 2)
}
\author{
T. Carruthers
}
