% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_SCA_CAL.R
\name{SCA_CAL}
\alias{SCA_CAL}
\title{Age-structured model using fishery length composition}
\usage{
SCA_CAL(
  x = 1,
  Data,
  AddInd = "B",
  SR = c("BH", "Ricker", "none"),
  vulnerability = c("logistic", "dome"),
  catch_eq = c("Baranov", "Pope"),
  CAL_dist = c("multinomial", "lognormal"),
  CAL_multiplier = 50,
  rescale = "mean1",
  max_age = Data@MaxAge,
  start = NULL,
  prior = list(),
  fix_h = TRUE,
  fix_F_equilibrium = TRUE,
  fix_omega = TRUE,
  fix_tau = TRUE,
  LWT = list(),
  early_dev = c("comp_onegen", "comp", "all"),
  late_dev = "comp50",
  integrate = FALSE,
  silent = TRUE,
  opt_hess = FALSE,
  n_restart = ifelse(opt_hess, 0, 1),
  control = list(iter.max = 2e+05, eval.max = 4e+05),
  inner.control = list(),
  ...
)
}
\arguments{
\item{x}{A position in the Data object (by default, equal to one for assessments).}

\item{Data}{An object of class Data}

\item{AddInd}{A vector of integers or character strings indicating the indices to be used in the model. Integers assign the index to
the corresponding index in Data@AddInd, "B" (or 0) represents total biomass in Data@Ind, "VB" represents vulnerable biomass in
Data@VInd, and "SSB" represents spawning stock biomass in Data@SpInd. Vulnerability to the survey is fixed in the model.}

\item{SR}{Stock-recruit function (either \code{"BH"} for Beverton-Holt, \code{"Ricker"}, or \code{"none"} for constant mean recruitment).}

\item{vulnerability}{Whether estimated vulnerability is \code{"logistic"} or \code{"dome"} (double-normal).
See details for parameterization.}

\item{catch_eq}{Whether to use the Baranov equation or Pope's approximation to calculate the predicted catch at age in the model.}

\item{CAL_dist}{Character, the statistical distribution for the likelihood of the catch-at-length.}

\item{CAL_multiplier}{Numeric for data weighting of catch-at-length matrix if \code{CAL_hist = "multinomial"}. A value smaller than one
rescales annual sample sizes to this fraction of the original sample size. Values greater than one generates a cap of the annual sample
size to this value.}

\item{rescale}{A multiplicative factor that rescales the catch in the assessment model, which
can improve convergence. By default, \code{"mean1"} scales the catch so that time series mean is 1, otherwise a numeric.
Output is re-converted back to original units.}

\item{max_age}{Integer, the maximum age (plus-group) in the model.}

\item{start}{Optional list of starting values. Entries can be expressions that are evaluated in the function. See details.}

\item{prior}{A named list (R0, h, M, and q) to provide the mean and standard deviations of prior distributions for those parameters. R0, index q, and M priors are
lognormal (provide the mean in normal space, SD in lognormal space). Beverton-Holt steepness uses a beta prior, while Ricker steepness uses a normal prior.
For index q, provide a matrix for nsurvey rows and 2 columns (for mean and SD), with NA in rows corresponding to indices without priors
For all others, provide a length-2 vector for the mean and SD.
See vignette for full description.}

\item{fix_h}{Logical, whether to fix steepness to value in \code{Data@steep} in the model for \code{SCA}. This only affects
calculation of reference points for \code{SCA2}.}

\item{fix_F_equilibrium}{Logical, whether the equilibrium fishing mortality prior to the first year of the model
is estimated. If \code{TRUE}, \code{F_equilibrium} is fixed to value provided in \code{start} (if provided),
otherwise, equal to zero (assumes unfished conditions).}

\item{fix_omega}{Logical, whether the standard deviation of the catch is fixed. If \code{TRUE},
omega is fixed to value provided in \code{start} (if provided), otherwise, value based on \code{Data@CV_Cat}.}

\item{fix_tau}{Logical, the standard deviation of the recruitment deviations is fixed. If \code{TRUE},
tau is fixed to value provided in \code{start} (if provided), otherwise, value based on \code{Data@sigmaR}.}

\item{LWT}{A named list (Index, CAA, Catch) of likelihood weights for the data components. For the index, a vector of length survey. For
CAL and Catch, a single value.}

\item{early_dev}{Numeric or character string describing the years for which recruitment deviations are estimated in \code{SCA}. By default,
equal to \code{"comp_onegen"}, where rec devs are estimated one full generation prior to the first year when catch-at-age (CAA) data are available.
With \code{"comp"}, rec devs are estimated starting in the first year with CAA. With \code{"all"}, rec devs start at the beginning of the model.
If numeric, the number of years after the first year of the model for which to start estimating rec devs. Use negative numbers for years prior to the first year.}

\item{late_dev}{Typically, a numeric for the number of most recent years in which recruitment deviations will
not be estimated in \code{SCA} (recruitment in these years will be based on the mean predicted by stock-recruit relationship).
By default, \code{"comp50"} uses the number of ages (smaller than the mode)
for which the catch-at-age matrix has less than half the abundance than that at the mode.}

\item{integrate}{Logical, whether the likelihood of the model integrates over the likelihood
of the recruitment deviations (thus, treating it as a random effects/state-space variable).
Otherwise, recruitment deviations are penalized parameters.}

\item{silent}{Logical, passed to \code{\link[TMB]{MakeADFun}}, whether TMB
will print trace information during optimization. Used for diagnostics for model convergence.}

\item{opt_hess}{Logical, whether the hessian function will be passed to \code{\link[stats]{nlminb}} during optimization
(this generally reduces the number of iterations to convergence, but is memory and time intensive and does not guarantee an increase
in convergence rate). Ignored if \code{integrate = TRUE}.}

\item{n_restart}{The number of restarts (calls to \code{\link[stats]{nlminb}}) in the optimization procedure, so long as the model
hasn't converged. The optimization continues from the parameters from the previous (re)start.}

\item{control}{A named list of arguments for optimization to be passed to
\code{\link[stats]{nlminb}}.}

\item{inner.control}{A named list of arguments for optimization of the random effects, which
is passed on to \code{\link[TMB]{newton}}.}

\item{...}{Other arguments to be passed.}
}
\description{
A single-fleet assessment that fits to catch, indices of abundance, and fishery length compositions. See \link{SCA} for all details.
}
\section{Online Documentation}{

Model description and equations are available on the openMSE 
\href{https://openmse.com/features-assessment-models/2-sca/}{website}.
}

\author{
Q. Huynh
}
