% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_indicators.R
\name{summarize_indicators}
\alias{summarize_indicators}
\title{Presents point, MSE and CV estimates}
\usage{
summarize_indicators(object, indicator = "all", MSE = FALSE, CV = FALSE)
}
\arguments{
\item{object}{Object for which point and/or MSE estimates and/or
calculated CV's are requested. The object must be of class \code{SAEforest}.}

\item{indicator}{Optional character vector specifying indicators to be mapped: (i)
all calculated indicators ("all"); (ii) each default indicators name: "Mean",
"Quant10", "Quant25", "Median", "Quant75", "Quant90", "Gini", "Hcr", "Pgap", "Qsr"
or the function name/s of "custom_indicator/s"; (iii) a vector of names of indicators.
If the \code{object} is estimated by \code{\link{SAEforest_model}} indicator arguments
are ignored and only the "Mean" is returned.}

\item{MSE}{Logical. If \code{TRUE}, MSE estimates for selected indicators
per domain are added to the data frame of point estimates. Defaults to \code{FALSE}.}

\item{CV}{Logical. If \code{TRUE}, coefficients of variation for selected
indicators per domain are added to the data frame of point estimates. Defaults to \code{FALSE}.}
}
\value{
The return of \code{summarize_indicators} is an object of class \code{summarize_indicators.SAEforest}
including domain-specific point and/or MSE estimates and/or calculated CV's from a \code{SAEforest} object
The returned object contains the data.frame \code{ind} and a character including the names of requested indicator(s).
}
\description{
Function \code{summarize_indicators} reports point and
mean squared error (MSE) estimates as well as calculated coefficients of variation
(CV) from a fitted \code{SAEforest} object.
}
\details{
Objects of class \code{summarize_indicators.SAEforest} have methods for following generic
functions: \code{head} and \code{tail} (for default documentation, see
\code{\link[utils]{head}}),  \code{as.matrix} (for default documentation, see
\code{\link[base]{matrix}}), \code{as.data.frame} (for default documentation,
see \code{\link[base]{as.data.frame}}), \code{subset} (for default
documentation, see \code{\link[base]{subset}}).
}
\examples{
\donttest{
# Loading data
data("eusilcA_pop")
data("eusilcA_smp")

income <- eusilcA_smp$eqIncome
X_covar <- eusilcA_smp[, -c(1, 16, 17, 18)]

# Calculating point + MSE estimates and passing arguments to the forest.
# Additionally, two additional indicators and functions as threshold are added.
# Note that B and num.trees are low to speed up estimation time and must be changed for
# practical applications.

model1 <- SAEforest_model(Y = income, X = X_covar, dName = "district",
                          smp_data = eusilcA_smp, pop_data = eusilcA_pop,
                          meanOnly = FALSE, MSE = "nonparametric", B = 5, mtry = 5,
                          num.trees = 50, smearing = FALSE)

# Extract indicator and show generics:
Gini1 <- summarize_indicators(model1, MSE = TRUE, CV = TRUE, indicator = "Gini")

head(Gini1)
tail(Gini1)
as.data.frame(Gini1)
as.matrix(Gini1)
subset(Gini1, district == "Wien")
}
}
\seealso{
\code{\link{SAEforestObject}}, \code{\link{SAEforest_model}}
}
