% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SACOBRA.R
\docType{package}
\name{SACOBRA-package}
\alias{SACOBRA-package}
\alias{SACOBRA}
\title{Self-adjusting Constrained Optimization with RBF Surrogates}
\description{
Self-adjusting Constrained Optimization with RBF Surrogates
}
\details{
\tabular{ll}{
Package: \tab SACOBRA\cr
Type: \tab Package\cr
Version: \tab 1.1\cr
Date: \tab 16.08.2019\cr
License: \tab GPL (>= 2)\cr
LazyLoad: \tab yes\cr
}

SACOBRA is a package for numeric constrained optimization of expensive black-box functions under severely 
limited budgets. The problem to solve is: 
\deqn{ \mbox{Minimize}\quad  f(\vec{x}) , \vec{x} \in [\vec{a},\vec{b}] \subset \mathbf{R}^d }
\deqn{ \mbox{subject to}\quad g_i(\vec{x}) \le 0, i=1,\ldots,m    }
\deqn{ \mbox{~~~~~~~~~~}\quad\quad h_j(\vec{x}) = 0, j=1,\ldots,r.    }

SACOBRA is an extension of the COBRA algorithm by Regis (R. Regis: "Constrained 
optimization by radial basis function interpolation for high-dimensional expensive black-box 
problems with infeasible initial points", Engineering Optimization, Taylor & Francis, 46, p. 218-243, 2013)

These extensions include: \cr
1) A repair algorithm for infeasible solutions, \cr
2) an algorithm for handling equality constraints, \cr
3) several internal optimizers and several initial design generation methods,  \cr
4) self-adjusting random restart algorithm,  \cr
5) self-adjusting logarithmic transform for objective functions with large output ranges,  \cr
6) range normalization of constraint functions, \cr
7) self-adjusting DRC (distance requirement cycle) selection, \cr
8) online model selection to select the best type of RBF for objective and constraint functions, \cr
9) online whitening for unconstrained optimization of functions with high conditioning. \cr
(Please note that the online whitening implementation is still underway and at this stage it is not recommended to be applied to expensive problems) 

SACOBRA performs optimization with a minimum of true function evaluations. It has proven
to work well on problems with high dimensions (e.g. d=124) and many constraints (e.g. 60).
It is usable for all kind of numerical optimization of continuous functions, but not for combinatorial optimization.

For more details see:\cr
\itemize{
   \item Bagheri, S.; Konen, W.; Emmerich, M.; Baeck, T.: "Self-adjusting parameter control for surrogate-assisted constrained optimization under limited budgets".
In: Journal of Applied Soft Computing, Band 61, pages 377-393, 2017,
\url{https://www.researchgate.net/publication/319012980_Self-adjusting_parameter_control_for_surrogate-assisted_constrained_optimization_under_limited_budgets} \cr   
   \item Bagheri, S.; Konen, W.; Baeck, T.:"Online selection of surrogate models for constrained black-box optimization".
In: IEEE Symposium Series on Computational Intelligence (SSCI), 2016,
\url{http://www.gm.fh-koeln.de/~konen/Publikationen/Bagh16-SSCI.pdf}   \cr
   \item Koch, P.; Bagheri, S.; Konen, W. et al.: "A New Repair Method For Constrained Optimization". 
In: Proceedings of the 17th Genetic and Evolutionary Computation Conference, 2015, 
\url{http://www.gm.fh-koeln.de/~konen/Publikationen/Koch2015a-GECCO.pdf} \cr
   \item Koch, P.; Bagheri, S. et al.: "Constrained Optimization with a Limited Number of Function Evaluations"
In: W. Hoffmann, F. & Huellermeier, E. (Eds.),  Proceedings 24. Workshop Computational Intelligence, 
Universitaetsverlag Karlsruhe, 2014, 119-134, 
\url{http://www.gm.fh-koeln.de/~konen/Publikationen/Koch2014a-GMA-CI.pdf}.
}

The main entry point functions are \code{\link{cobraInit}} and \code{\link{startCobra}}. 
See \code{\link{cobraInit}} for an overview of adjustable SACOBRA-parameters.
Examples are found in
\itemize{
   \item \code{\link{startCobra}}: solve a 13d-problem with 9 inequality constraints (G01)
   \item \code{\link{cobraInit}}: a problem with equality constraint 
   \item \code{\link{cobraPhaseII}}: unconstrained sphere problem 
   \item \code{\link{multiCOBRA}}: solve G11 problem nrun=4 times 
   \item \code{\link{COP}}: load and solve G24, load and solve the scalable problem G03 with d=3 
}
}
\references{
\url{http://lwibs01.gm.fh-koeln.de/blogs/ciop/research/monrep/}
}
\author{
Samineh Bagheri (\email{Samineh.Bagheri@th-koeln.de}), \cr
Wolfgang Konen (\email{Wolfgang.Konen@th-koeln.de}), \cr
Patrick Koch, Thomas Baeck (\email{t.h.w.baeck@liacs.leidenuniv.nl})
}
\keyword{RBF}
\keyword{black-box}
\keyword{constraints}
\keyword{optimization}
\keyword{package}
\keyword{surrogate}
