% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelSelection.R
\name{defaultMS}
\alias{defaultMS}
\title{Default settings for the model-selection part of SACOBRA.}
\usage{
defaultMS()
}
\value{
MS,  a list with the following elements 
     \item{active}{[F] If set to TRUE then \code{selectModel} calculates the best model for each constraint(s)/objective function }
     \item{models}{[c("cubic","MQ")] a set of model types that will be used to build the pool of models. Three types of RBF are implemneted "cubic", "Gaussian" and "MQ" (multiquadric). 
Users can select one or combination of these models. Users can select a set of "width parameters" for "MQ" and "Gaussian" by setting \code{widths} parameter. }
     \item{widths}{[c(0.01,0.1,1,10)] a set of values for width parameter of RBF models. Only relevant if \code{models} include "Gaussian" or "MQ". } 
     \item{freq}{[1] controls how often \code{selectModel} is called. 
     In every \code{freq} iterations all the selected models are trained for all constraint/objective function(s)}
     \item{slidingW}{[T] when set to FALSE it uses the information taken from all the past iterations to asses the quality of the models. 
     When set to TRUE, activates the sliding window functionality and it takes the information of the last \code{WinS} iterations (see \code{WinS}).}
     \item{WinS}{[1] size of the sliding window }
     \item{quant}{[3] 3: median, 2:0.25, 4:0.75. The measure used to compare the quality of the model in the last window.}
     \item{apply}{[T] if set to FALSE then the selected models are not used during the optimization. Only for debugging purposes. }
     \item{considerXI}{[F] If set to T then a subset of the approximation errors which are related to the current (DRC element) 
     are considered to make the model selection decision}
}
\description{
Sets default values for the model-selection part \code{cobra$MS} of SACOBRA.  \cr
It is shown that different types of RBFs can deliver different qualites in modeling different functions. 
Using the online model selection functionality boosted the overall performace of SACOBRA on a large set of constrained problems.
The algorithm trains every function (objective and constraints) with a given pool of models including different RBF types and width parameters.
The type of model which performs the best in the last iterations \code{WinS} will be selected for each function. 
The quality of the models are determined by different measures of approximation error in each iteration
\deqn{f(\vec{x}_{new})-s(\vec{x}_{new})}
}
\details{
With the call \code{\link{setOpts}(MS,defaultMS())} it is possible to extend a partial list 
\code{MS} to a list containing all \code{MS}-elements (the missing ones are taken from 
\code{defaultMS()}).\cr \cr
\strong{NOTE:} Because of common crash observation, it is not recommended to include Gaussian model in the set of models especially for problems which require more than 100 function evaluations.
}
\seealso{
\code{\link{setOpts}}
}
\author{
Samineh Bagheri
}
