## ----setup, include=FALSE------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ---- message=FALSE------------------------------------------------------
library(Ryacas)

## ------------------------------------------------------------------------
L1chr <- diag(4)
L1chr[2:4, 1] <- "-a"
L1 <- ysym(L1chr)
L1

## ------------------------------------------------------------------------
L1inv <- solve(L1)
K1 <- t(L1) %*% L1
V1 <- L1inv %*% t(L1inv)

## ---- results="asis"-----------------------------------------------------
cat(
  "\\begin{align} 
    K_1 &= ", tex(K1), " \\\\ 
   V_1 &= ", tex(V1), " 
  \\end{align}", sep = "")

## ------------------------------------------------------------------------
L2chr <- diag(4)
L2chr[2:4, 1] <- c("-a1", "-a2", "-a3")
L2 <- ysym(L2chr)
L2
Vechr <- diag(4)
Vechr[cbind(1:4, 1:4)] <- c("w1", "w2", "w2", "w2")
Ve <- ysym(Vechr)
Ve

## ------------------------------------------------------------------------
L2inv <- solve(L2)
K2 <- t(L2) %*% solve(Ve) %*% L2
V2 <- L2inv %*% Ve %*% t(L2inv)

## ---- results="asis"-----------------------------------------------------
cat(
  "\\begin{align} 
    K_2 &= ", tex(K2), " \\\\ 
   V_2 &= ", tex(V2), " 
  \\end{align}", sep = "")

