% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxCbindStudyIndividual.R
\name{rxCbindStudyIndividual}
\alias{rxCbindStudyIndividual}
\title{Bind the study parameters and individual parameters}
\usage{
rxCbindStudyIndividual(studyParameters, individualParameters)
}
\arguments{
\item{studyParameters}{These are the study parameters, often can
be generated by sampling from a population.  This can be either
a matrix or a data frame}

\item{individualParameters}{A data frame of individual parameters}
}
\value{
Data frame that can be used in RxODE simulations
}
\description{
Bind the study parameters and individual parameters
}
\examples{

# Function for coverting coefficient of covariance into a variance
lognCv <- function(x){log((x/100)^2+1)}

set.seed(32)

nSub  <-  100
nStud  <-  10

#define theta
theta <- c(lka=log(0.5), # log ka
          lCl=log(5), # log Cl
          lV=log(300) # log V
          )

#define theta Matrix
thetaMat <- lotri(lCl ~ lognCv(5),
                 lV  ~ lognCv(5),
                 lka ~ lognCv(5))


nev <- nSub*nStud

ev1 <- data.frame(COV1=rnorm(nev,50,30),COV2=rnorm(nev,75,10),
                  COV3=sample(c(1.0,2.0),nev,replace=TRUE))


tmat <-rxRmvn(nStud, theta[dimnames(thetaMat)[[1]]], thetaMat)

rxCbindStudyIndividual(tmat, ev1)

}
\author{
Matthew Fidler
}
