% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcgClost.r
\name{vcgClost}
\alias{vcgClost}
\title{Project coordinates onto a target triangular surface mesh.}
\usage{
vcgClost(
  x,
  mesh,
  sign = TRUE,
  barycentric = FALSE,
  smoothNormals = FALSE,
  borderchk = FALSE,
  tol = 0,
  facenormals = FALSE,
  ...
)
}
\arguments{
\item{x}{k x 3 matrix containing 3D-coordinates or object of class "mesh3d".}

\item{mesh}{triangular surface mesh stored as object of class "mesh3d".}

\item{sign}{logical: if TRUE, signed distances are returned.}

\item{barycentric}{logical: if TRUE, barycentric coordinates of the hit
points are returned.}

\item{smoothNormals}{logical: if TRUE, laplacian smoothed normals are used.}

\item{borderchk}{logical: request checking if the hit face is at the border of the mesh.}

\item{tol}{maximum distance to search. If distance is beyond that, the original point will be kept and the distance set to NaN. If tol = 0, tol is set to 2*diagonal of the bounding box of \code{mesh}.}

\item{facenormals}{logical: if TRUE only the facenormal of the face the closest point has hit is returned, the weighted average of the surrounding vertex normals otherwise.}

\item{...}{additional parameters, currently unused.}
}
\value{
returns an object of class "mesh3d" with:
\item{vb }{4 x n matrix containing n vertices as homolougous coordinates.}
\item{normals }{4 x n matrix containing vertex normals.}
\item{quality }{numeric vector containing distances to target.}
\item{it }{3 x m integer matrix containing vertex indices forming triangular
faces.Only available, when x is a mesh.}
\item{border }{integer vector of length n: if borderchk = TRUE, for each clostest point the value will be 1 if the hit face is at the border of the target mesh and 0 otherwise.} 
\item{barycoords }{3 x m Matrix containing barycentric coordinates of
closest points; only available if barycentric=TRUE.}
\item{faceptr }{vector of face indeces on which the closest points are located}
}
\description{
For a set of 3D-coordinates/triangular mesh, the closest matches on a
target surface are determined and normals at as well as distances to
that point are calculated.
}
\note{
If large part of the reference mesh are far away from the target
surface, calculation can become very slow. In that case, the function
\code{vcgClostKD} will be significantly faster.
}
\examples{
data(humface)
clost <- vcgClost(humface.lm, humface)




}
\references{
Baerentzen, Jakob Andreas. & Aanaes, H., 2002. Generating Signed
Distance Fields From Triangle Meshes. Informatics and Mathematical
Modelling.
}
\seealso{
\code{\link{vcgPlyRead}}
}
\author{
Stefan Schlager
}
