% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcgCreateKD.r
\name{vcgSearchKDtree}
\alias{vcgSearchKDtree}
\title{search an existing KD-tree}
\usage{
vcgSearchKDtree(kdtree, query, k, threads = 0)
}
\arguments{
\item{kdtree}{object of class vcgKDtree}

\item{query}{atrix or triangular mesh containing coordinates}

\item{k}{number of k-closest neighbours to query}

\item{threads}{integer: number of threads to use}
}
\value{
a list with
\item{index}{integer matrices with indeces of closest points}
\item{distances}{corresponding distances}
}
\description{
search an existing KD-tree
}
\examples{
data(humface);data(dummyhead)
mytree <- vcgCreateKDtree(humface)
## get indices and distances for 10 closest points.
closest <- vcgSearchKDtree(mytree,dummyhead.mesh,k=10,threads=1)
}
\seealso{
\code{\link{vcgCreateKDtree}}
}

