% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ppower}
\alias{ppower}
\title{Returns CDF from EP Distribution}
\usage{
ppower(x, m = 0, a = 1, b = 2)
}
\arguments{
\item{x}{(numeric) - value in the range \eqn{(-\infty, \infty)} to evaluate
the density.}

\item{m}{(numeric) - location parameter. Must be in the range}

\item{a}{(numeric) - scale parameter. Must be in the range \eqn{(0, \infty)}.}

\item{b}{(numeric) - shape parameter. Must be in the range \eqn{(0, \infty)}.
\eqn{(-\infty, \infty)}.}
}
\value{
a vector containing the values for the probabilities.
}
\description{
The \code{ppower} returns the Cumulative Distribution Function at point x for
the Exponential Power distribution with parameters \eqn{a}, \eqn{b} and \eqn{m}.
}
\details{
The Exponential Power distribution (EP) is given by the function:
\deqn{ f(a,b) = \frac{1}{2a\Gamma(1+1/b)}e^{-|(x-m)/a|^b}, -\infty < x < \infty }.
where \eqn{b} is a shape parameter, \eqn{a} is a scale parameter, \eqn{m}
is a location parameter and \eqn{\Gamma} represents the gamma function.
}
