% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefineAndUpdateVariables.R
\name{DefineTranslation}
\alias{DefineTranslation}
\title{Define translation}
\usage{
DefineTranslation(
  processData,
  UseProcessData = FALSE,
  DefinitionMethod = c("ResourceFile", "TranslationTable"),
  TranslationTable = data.table::data.table(),
  FileName
)
}
\arguments{
\item{processData}{The current data produced by a previous instance of the function.}

\item{UseProcessData}{Logical: If TRUE use the existing function output in the process.}

\item{DefinitionMethod}{Character: A string naming the method to use, one of "TranslationTable" for defining the \code{TranslationTable}, and "ResourceFile" for reading the table from the file given by \code{FileName}.}

\item{TranslationTable}{A table of the columns "VariableName", representing the variable to translate; "Value", giving the values to translate; and "NewValue", giving the values to translate to.}

\item{FileName}{The csv file holding a table with the three variables listed for \code{TranslationTable}.}
}
\value{
A \code{\link{Translation}} object.
}
\description{
This function defines the translation table used as input to \code{\link{TranslateStoxBiotic}} and similar functions to translate values of one or more columns to new values given by a table or read from a CSV file.
}
