% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RsqMed_sd.R
\name{CI.Rsq.measure}
\alias{CI.Rsq.measure}
\title{Functions to generate the confidence interval of the Rsq measure using nonparametric bootstrap.}
\usage{
CI.Rsq.measure(
  p = 1/2,
  Y,
  M,
  Covar = NULL,
  X,
  method = c("iSIS", "ALL"),
  B = 200,
  iter.max = 3,
  nsis = NULL,
  init.FDR.cutoff = 0.1,
  filtering = F
)
}
\arguments{
\item{p}{Proportion of the training dataset for selecting mediators regarding to the whole dataset, default is set as 1/2}

\item{Y}{Vector of outcome type of interest; Only Gaussian distributed outcome is accepted.}

\item{M}{Matrix of putative mediators}

\item{Covar}{Covariate matrix}

\item{X}{Vector of the exposure or independent variable of interest, e.g. environmental exposure}

\item{method}{Method used to screen out non-mediators. When no variable selection is required, method='ALL'; otherwise, iterative sure independence screening (SIS) is used for variable selection, i.e., method='iSIS'.}

\item{B}{Number of bootstrap samples, default is 100}

\item{iter.max}{Maximum number of iteration used in iSIS, default=10 (details see the SIS package)}

\item{nsis}{Number of pedictors recruited by iSIS}

\item{init.FDR.cutoff}{FDR threshold for the filtering method on M1 type of mediators.}

\item{filtering}{T: filtering mediators based on the strength of indp and mediators as a preprocessing step; F: all putative mediators are included, default=F.}
}
\value{
CI: The 95 percent confidence intervals of Rsq measure (Rsq.mediated), shared over simple effects (SOS), number of mediators selected (pab), variance of outcome explained by mediator (Rsq.YM), variance of outcome explained by the independent variable (Rsq.YX), and variance of outcome explained by mediator and independent variable (Rsq.YMX). The estimates for each bootstrap are also returned.
}
\description{
Functions to generate the confidence interval of the Rsq measure using nonparametric bootstrap.
}
\examples{
{
 \dontrun{
data(example)
attach(example)
CI.Rsq.measure( p=1/2, Y=Y,M=M,X=X,method='ALL', B=1, iter.max=1)
}
}
}
