% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_prime.R
\name{is_prime}
\alias{is_prime}
\title{Check if a number is prime}
\usage{
is_prime(n)
}
\arguments{
\item{n}{(numeric) Number to verify if it prime}
}
\value{
(bool) TRUE if the number is prime, FALSE if the number is not prime
}
\description{
To check if a number n is prime, you only need to check for factors up to the square root of n.
This is because if n has a factor greater than its square root, it must also have a smaller factor
(since a factor is a number that divides n without leaving a remainder).
This method significantly reduces the number of checks needed to determine if a number is prime.
}
\examples{
is_prime(0)
is_prime(1)
is_prime(7)
is_prime(10)
is_prime(100011869)
}
