% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_empty_sels.R
\name{exp_empty_sels}
\alias{exp_empty_sels}
\title{Export a 'Raven' selection for all sound files in a folder}
\usage{
exp_empty_sels(path = NULL, file.name = NULL, pb = TRUE)
}
\arguments{
\item{path}{A character string indicating the path of the directory in which to look for sound files.
If not provided (default) the function will use the current working directory.}

\item{file.name}{Name of the output .txt file. If \code{NULL} then the folder name is used instead.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}
}
\value{
The function saves a selection table in '.txt' format that can be 
directly opened in Raven.
No objects are returned in the R environment.
}
\description{
\code{exp_empty_sels} exports a 'Raven' selection data in .txt format that includes empty selections for all sound files in a folder.
}
\details{
The function saves a selection file in '.txt' format (that can be 
directly opened in Raven) that will display all sound files in the provided
directory (argument 'path'). Useful to simplify the making of selections from several sound files that need to be displayed simultaneously (e.g. several recordings from the same individual). The selection file is saved in the provided directory ('path').
}
\examples{

# Load data
library(NatureSounds)
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "lbh_selec_table"))

## Export a single selection table including multiple files
#save sound files 
tuneR::writeWave(Phae.long1, file.path(tempdir(), 
"Phae.long1.wav"), extensible = FALSE) 
tuneR::writeWave(Phae.long2, file.path(tempdir(), 
"Phae.long2.wav"), extensible = FALSE)
tuneR::writeWave(Phae.long3, file.path(tempdir(), 
"Phae.long3.wav"), extensible = FALSE)
tuneR::writeWave(Phae.long4, file.path(tempdir(), 
"Phae.long4.wav"), extensible = FALSE)

# export with no file name
exp_empty_sels(path = tempdir())

# export with file name
exp_empty_sels(file.name = "Phaethornis.longirostris", path = tempdir())

}
\seealso{
\code{\link{exp_raven}}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
