% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_raven.R
\name{exp_raven}
\alias{exp_raven}
\title{Export 'Raven' selections}
\usage{
exp_raven(X, path = NULL, file.name = NULL, khz.to.hz = TRUE, 
sound.file.path = NULL, single.file = TRUE, parallel = 1, pb = TRUE)
}
\arguments{
\item{X}{Object of class data frame or \code{\link[warbleR]{selection_table}} containing columns for sound file (sound.files), selection (selec), start and end time of signals ('start' and 'end') and low and high frequency ('bottom.freq' and 'top.freq', optional). See example data 'selec_table' in the \code{\link{warbleR}}) package.}

\item{path}{A character string indicating the path of the directory in which to save the selection files.
If not provided (default) the function saves the file into the current working directory.}

\item{file.name}{Name of the output .txt file. If \code{NULL} then the sound file names are used instead. If multiple
selection files are generated (see 'single.file') then the sound files names are added to the provided 'file.name'.}

\item{khz.to.hz}{Logical. Controls if frequency variables should be converted from kHz (the unit used by other bioacoustic analysis R packages like \code{\link{warbleR}}) to Hz (the unit used by Raven). Default is \code{TRUE}.}

\item{sound.file.path}{A character string indicating the path of the 
directory containing the sound file(s). Providing this information allows
 to open both sound file and selection table simultaneously. This can be
 done by using the 'File > Open selection table' option in 'Raven' (or drag/drop the 
selection file into Raven). Default is \code{NULL}. This argument is required when
exporting selections from multiple sound files.}

\item{single.file}{Logical. Controls whether a single selection file (\code{TRUE}; default)
or a selection file for each sound file (\code{FALSE}, hence, only applicable
when several sound files are included in 'X') are generated. Note that
'sound.file.path' must be provided when exporting several sound files into a single selection file as the
duration of the sound files is required.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}
}
\value{
The function saves a selection table in '.txt' format that can be 
directly opened in Raven. If several sound files are available users can either 
export them as a single selection file or as multiple selection files (one for each sound file). 
No objects are returned in the R environment.
}
\description{
\code{exp_raven} exports selection tables as 'Raven' selection data in .txt format.
}
\details{
The function exports selection tables (as the ones used in the R 
package \code{\link{warbleR}}) into the 'Raven' selection file format ('.txt').
 This can be useful to obtain additional Raven
measurements on existing selections by adding new measurements to the 
selection table once in Raven. Note that selection labels must be numeric and non-duplicated 
when exporting them to Raven. If that is not the case the function will
relabeled the selections and the previous selection labels will be retained in a new column ('old.selec').
}
\examples{

# Load data
library(warbleR)
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "lbh_selec_table"))

# Select data for a single sound file
st1 <- lbh_selec_table[lbh_selec_table$sound.files == "Phae.long1.wav", ]

# Export data of a single sound file
exp_raven(st1, file.name = "Phaethornis 1", path = tempdir())

# Export a single selection table including multiple files
tuneR::writeWave(Phae.long1, file.path(tempdir(), 
"Phae.long1.wav"), extensible = FALSE) #save sound files 
tuneR::writeWave(Phae.long2, file.path(tempdir(), 
"Phae.long2.wav"), extensible = FALSE)
tuneR::writeWave(Phae.long3, file.path(tempdir(), 
"Phae.long3.wav"), extensible = FALSE)
tuneR::writeWave(Phae.long4, file.path(tempdir(), 
"Phae.long4.wav"), extensible = FALSE)

# export raven selection as single file
exp_raven(X = lbh_selec_table, file.name = "Phaethornis multiple sound files",
single.file = TRUE, sound.file.path = tempdir(), path = tempdir())

}
\seealso{
\code{\link{imp_raven}}; \code{\link{imp_syrinx}}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
