% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rprofet.R
\name{WOE_custom}
\alias{WOE_custom}
\title{Custom Binning Numeric Variables}
\usage{
WOE_custom(dataset, var, target, breaks, right_bracket = F, color = "#0066CC")
}
\arguments{
\item{dataset}{Dataframe containing the target variable and desired numeric variables to be binned.}

\item{var}{A specific numeric attribute to be binned. Must be specified.}

\item{target}{A binary target variable. Must be specified.}

\item{breaks}{A vector of breakpoints for the desired bins. Must be specified.}

\item{right_bracket}{Logical. Specifying whether the intervals are closed on the right or the left.}

\item{color}{A hexadecimal value representing a specific color.}
}
\value{
A vector containing the newly binned values. Generates three barplots
displaying the worth of evidence (WoE), target rate and frequency across
all bins. The bars are arranged in an ascending order of WoE.
}
\description{
Function that bins a numeric variable based on user inputted breaks, plots the information on the new bins, and returns a vector of the newly binned values
}
\examples{
mydata <- ISLR::Default
mydata$default <- ifelse(mydata$default=="Yes", 1, 0) ## target coded with 1, 0
WC_1 <- WOE_custom(dataset=mydata, var="balance", target = "default",
           breaks=seq(0,3000,1000))
levels(factor(WC_1))
WC_2 <- WOE_custom(dataset=mydata, var="income", target = "default",
             breaks=seq(0,75000, 15000))
levels(factor(WC_2))

}
