% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_acf}
\alias{plot_acf}
\title{Autocorrelation plot of Gibbs samples}
\usage{
plot_acf(gibbs_samples, par_labels)
}
\arguments{
\item{gibbs_samples}{A matrix of Gibbs samples.}

\item{par_labels}{A character vector with labels for the Gibbs samples, of length equal to the
number of columns of \code{gibbs_samples}.}
}
\value{
No return value. Draws a plot to the current device.
}
\description{
This function plots the autocorrelation of the Gibbs samples. The plots
include the total Gibbs sample size \code{TSS} and the effective sample size
\code{ESS}, see the details.
}
\details{
The effective sample size is the value
\deqn{TSS / \sqrt{1 + 2\sum_{k\geq 1} \rho_k}},
where \eqn{\rho_k} is the auto correlation between the chain offset by
\eqn{k} positions. The auto correlations are estimated via
\code{\link[stats]{spec.ar}}.
}
\examples{
gibbs_samples <- matrix(arima.sim(list(order=c(1,0,0), ar = 0.5), n = 100))
RprobitB:::plot_acf(gibbs_samples, par_labels = "simulated AR(1) process")

}
\keyword{internal}
