% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public-lib.R
\name{getPolyhedron}
\alias{getPolyhedron}
\title{Get polyhedron}
\usage{
getPolyhedron(source = "netlib", polyhedron.name)
}
\arguments{
\item{source}{string vector, which can be obtained from getAvailableSources()}

\item{polyhedron.name}{a valid name of a polyhedron in
the database. Current names can be found with getAvailablePolyhedra()}
}
\value{
polyhedron R6 object
}
\description{
Gets a polyhedron from the database. It returns an R6 Class
with all its characteristics and functions.
The object returned, of type Polyhedron.class, allows to the
user to get access to all the functionality provided.
}
\examples{
tetrahedron <- getPolyhedron(source = 'netlib',
       polyhedron.name = 'tetrahedron')

# returns name of polyhedra
tetrahedron$getName()

# polyhedron state
tetrahedron.state <- tetrahedron$getState()

# Johnson symbol and Schlafli symbol
tetrahedron.state$getSymbol()

# vertex data.frame
tetrahedron.state$getVertices()

# List of faces of solid representation (3D)
tetrahedron.state$getSolid()

# List of faces of net representation (2D)
tetrahedron.state$getNet()
}
\seealso{
getAvailablePolyhedra, getAvailableSources
}
