% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notes.add.R
\name{notes.add}
\alias{notes.add}
\title{Add a note}
\usage{
notes.add(content, deal_id = NULL, person_id = NULL, org_id = NULL,
  add_time = NULL, pinned_to_deal_flag = NULL,
  pinned_to_organization_flag = NULL, pinned_to_person_flag = NULL,
  api_token = NULL, company_domain = "api",
  return_type = c("complete", "boolean"))
}
\arguments{
\item{content}{Content of the note in HTML format. Subject to sanitization on the back-end.}

\item{deal_id}{ID of the deal the note will be attached to.}

\item{person_id}{ID of the person this note will be attached to.}

\item{org_id}{ID of the organization this note will be attached to.}

\item{add_time}{Optional creation date & time of the Note in UTC. Can be set in the past or in the future. Requires admin user API token. Format: YYYY-MM-DD HH:MM:SS}

\item{pinned_to_deal_flag}{If set, then results are filtered by note to deal pinning state (deal_id is also required). This field has the following domains: (0; 1)}

\item{pinned_to_organization_flag}{If set, then results are filtered by note to organization pinning state (org_id is also required). This field has the following domains: (0; 1)}

\item{pinned_to_person_flag}{If set, then results are filtered by note to person pinning state (person_id is also required). This field has the following domains: (0; 1)}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Add a note on pipedrive.
}
\examples{
\donttest{
notes.add(content='e.g.',api_token='token',company_domain='exp')
}
}
