% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneandtrainIntLasso.R
\name{tuneandtrainIntLasso}
\alias{tuneandtrainIntLasso}
\title{Tune and Train Internal Lasso}
\usage{
tuneandtrainIntLasso(data, maxit = 120000, nlambda = 200, nfolds = 5)
}
\arguments{
\item{data}{A data frame containing the training data. The first column should be the response variable (factor), 
and the remaining columns should be the predictor variables.}

\item{maxit}{An integer specifying the maximum number of iterations. Default is 120000.}

\item{nlambda}{An integer specifying the number of lambda values to use in the Lasso model. Default is 200.}

\item{nfolds}{An integer specifying the number of folds for cross-validation. Default is 5.}
}
\value{
A list containing the best lambda value (`best_lambda`), the final trained model (`best_model`), 
  the AUC on the training data (`final_auc`), and the number of active coefficients (`active_set_Train`).
}
\description{
This function tunes and trains a Lasso classifier using the \code{glmnet} package. The function 
performs internal cross-validation to evaluate a sequence of lambda (regularization) values and 
selects the best model based on the Area Under the Curve (AUC).
}
\details{
This function trains a logistic Lasso model on the training dataset using cross-validation. 
The lambda value that results in the highest AUC during cross-validation is chosen as the best model, 
and the final model is trained on the full training dataset with this optimal lambda value.
}
\examples{
# Load sample data
data(sample_data_train)

# Example usage
result <- tuneandtrainIntLasso(sample_data_train, maxit = 120000, nlambda = 200, nfolds = 5)
result$best_lambda
result$best_model
result$final_auc
result$active_set_Train
}
